/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.registry.dependency;

import com.liferay.registry.Filter;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.dependency.ClassServiceDependencyVerifier;
import com.liferay.registry.dependency.FilterServiceDependencyVerifier;
import com.liferay.registry.dependency.ServiceDependencyVerifier;

public class ServiceDependency {
    private boolean _fulfilled;
    private final ServiceDependencyVerifier _serviceDependencyVerifier;
    private ServiceTracker<Object, Object> _serviceTracker;

    public ServiceDependency(Class<?> clazz) {
        this._serviceDependencyVerifier = new ClassServiceDependencyVerifier(clazz);
    }

    public ServiceDependency(Filter filter) {
        this._serviceDependencyVerifier = new FilterServiceDependencyVerifier(filter);
    }

    public void close() {
        this._serviceTracker.close();
        this._serviceTracker = null;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ServiceDependency serviceDependency = (ServiceDependency)object;
        return this._serviceDependencyVerifier.equals(serviceDependency._serviceDependencyVerifier);
    }

    public boolean fulfilled(ServiceReference<?> serviceReference) {
        this._fulfilled = this._serviceDependencyVerifier.verify(serviceReference);
        return this._fulfilled;
    }

    public int hashCode() {
        return this._serviceDependencyVerifier.hashCode();
    }

    public boolean isFulfilled() {
        return this._fulfilled;
    }

    public void open() {
        this._serviceTracker.open(true);
    }

    public void setServiceTracker(ServiceTracker<Object, Object> serviceTracker) {
        this._serviceTracker = serviceTracker;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(5);
        sb.append("{_fulfilled=");
        sb.append(this._fulfilled);
        sb.append(", _serviceDependencyVerifier=");
        sb.append(this._serviceDependencyVerifier);
        sb.append("}");
        return sb.toString();
    }
}

