/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.release.feature.flag.web.internal;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.release.feature.flag.ReleaseFeatureFlag;
import com.liferay.release.feature.flag.ReleaseFeatureFlagManager;
import com.liferay.release.feature.flag.web.internal.configuration.ReleaseFeatureFlagConfiguration;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.release.feature.flag.web.internal.configuration.ReleaseFeatureFlagConfiguration"}, service={ReleaseFeatureFlagManager.class})
public class ReleaseFeatureFlagManagerImpl
implements ReleaseFeatureFlagManager {
    private static final Log _log = LogFactoryUtil.getLog(ReleaseFeatureFlagManagerImpl.class);
    @Reference
    private ConfigurationProvider _configurationProvider;
    private volatile Set<ReleaseFeatureFlag> _disabledReleaseFeatureFlags = new HashSet<ReleaseFeatureFlag>();

    public boolean isEnabled(ReleaseFeatureFlag releaseFeatureFlag) {
        return !this._disabledReleaseFeatureFlags.contains(releaseFeatureFlag);
    }

    public void setEnabled(ReleaseFeatureFlag releaseFeatureFlag, boolean enabled) {
        if (enabled) {
            this._disabledReleaseFeatureFlags.remove(releaseFeatureFlag);
        } else {
            this._disabledReleaseFeatureFlags.add(releaseFeatureFlag);
        }
        try {
            this._configurationProvider.saveSystemConfiguration(ReleaseFeatureFlagConfiguration.class, (Dictionary)HashMapDictionaryBuilder.put((Object)"disabledReleaseFeatureFlags", (Object)ArrayUtil.toStringArray(this._disabledReleaseFeatureFlags)).build());
        }
        catch (ConfigurationException configurationException) {
            _log.error((Throwable)configurationException);
        }
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        ReleaseFeatureFlagConfiguration releaseFeatureFlagConfiguration = (ReleaseFeatureFlagConfiguration)ConfigurableUtil.createConfigurable(ReleaseFeatureFlagConfiguration.class, properties);
        this._disabledReleaseFeatureFlags.clear();
        for (String disabledReleaseFeatureFlag : releaseFeatureFlagConfiguration.disabledReleaseFeatureFlags()) {
            if (Validator.isNull((String)disabledReleaseFeatureFlag)) continue;
            try {
                this._disabledReleaseFeatureFlags.add(ReleaseFeatureFlag.valueOf((String)disabledReleaseFeatureFlag));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                _log.error((Throwable)illegalArgumentException);
            }
        }
    }
}

