/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.remote.app.service.impl;

import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.remote.app.exception.DuplicateRemoteAppEntryURLException;
import com.liferay.remote.app.model.RemoteAppEntry;
import com.liferay.remote.app.service.base.RemoteAppEntryLocalServiceBaseImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;

@Component(property={"model.class.name=com.liferay.remote.app.model.RemoteAppEntry"}, service={AopService.class})
public class RemoteAppEntryLocalServiceImpl
extends RemoteAppEntryLocalServiceBaseImpl {
    @Indexable(type=IndexableType.REINDEX)
    public RemoteAppEntry addRemoteAppEntry(long userId, Map<Locale, String> nameMap, String url, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        long companyId = user.getCompanyId();
        this.validate(companyId, 0L, url);
        long remoteAppEntryId = this.counterLocalService.increment();
        RemoteAppEntry remoteAppEntry = this.remoteAppEntryPersistence.create(remoteAppEntryId);
        remoteAppEntry.setUuid(serviceContext.getUuid());
        remoteAppEntry.setCompanyId(companyId);
        remoteAppEntry.setUserId(user.getUserId());
        remoteAppEntry.setUserName(user.getFullName());
        remoteAppEntry.setNameMap(nameMap);
        remoteAppEntry.setUrl(url);
        return (RemoteAppEntry)this.remoteAppEntryPersistence.update((BaseModel)remoteAppEntry);
    }

    public List<RemoteAppEntry> searchRemoteAppEntries(long companyId, String keywords, int start, int end, Sort sort) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(companyId, keywords, start, end, sort);
        return this.searchRemoteAppEntries(searchContext);
    }

    public int searchRemoteAppEntriesCount(long companyId, String keywords) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(companyId, keywords, -1, -1, null);
        return this.searchRemoteAppEntriesCount(searchContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public RemoteAppEntry updateRemoteAppEntry(long remoteAppEntryId, Map<Locale, String> nameMap, String url, ServiceContext serviceContext) throws PortalException {
        this.validate(serviceContext.getCompanyId(), remoteAppEntryId, url);
        RemoteAppEntry remoteAppEntry = this.remoteAppEntryPersistence.findByPrimaryKey(remoteAppEntryId);
        remoteAppEntry.setNameMap(nameMap);
        remoteAppEntry.setUrl(url);
        return (RemoteAppEntry)this.remoteAppEntryPersistence.update((BaseModel)remoteAppEntry);
    }

    protected SearchContext buildSearchContext(long companyId, String keywords, int start, int end, Sort sort) {
        SearchContext searchContext = new SearchContext();
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        searchContext.setAttributes((Map)HashMapBuilder.put((Object)"name", (Object)keywords).put((Object)"url", (Object)keywords).build());
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        searchContext.setKeywords(keywords);
        if (sort != null) {
            searchContext.setSorts(new Sort[]{sort});
        }
        searchContext.setStart(start);
        return searchContext;
    }

    protected List<RemoteAppEntry> getRemoteAppEntries(Hits hits) throws PortalException {
        List documents = hits.toList();
        ArrayList<RemoteAppEntry> remoteAppEntries = new ArrayList<RemoteAppEntry>(documents.size());
        for (Document document : documents) {
            long remoteAppEntryId = GetterUtil.getLong((String)document.get("entryClassPK"));
            RemoteAppEntry remoteAppEntry = this.remoteAppEntryPersistence.fetchByPrimaryKey(remoteAppEntryId);
            if (remoteAppEntry == null) {
                remoteAppEntries = null;
                Indexer indexer = IndexerRegistryUtil.getIndexer(RemoteAppEntry.class);
                long companyId = GetterUtil.getLong((String)document.get("companyId"));
                indexer.delete(companyId, document.getUID());
                continue;
            }
            remoteAppEntries.add(remoteAppEntry);
        }
        return remoteAppEntries;
    }

    protected List<RemoteAppEntry> searchRemoteAppEntries(SearchContext searchContext) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(RemoteAppEntry.class);
        for (int i = 0; i < 10; ++i) {
            Hits hits = indexer.search(searchContext);
            List<RemoteAppEntry> remoteAppEntries = this.getRemoteAppEntries(hits);
            if (remoteAppEntries == null) continue;
            return remoteAppEntries;
        }
        throw new SearchException("Unable to fix the search index after 10 attempts");
    }

    protected int searchRemoteAppEntriesCount(SearchContext searchContext) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(RemoteAppEntry.class);
        return GetterUtil.getInteger((Object)indexer.searchCount(searchContext));
    }

    protected void validate(long companyId, long remoteAppEntryId, String url) throws PortalException {
        RemoteAppEntry remoteAppEntry = this.remoteAppEntryPersistence.fetchByC_U(companyId, StringUtil.trim((String)url));
        if (remoteAppEntry != null && remoteAppEntry.getRemoteAppEntryId() != remoteAppEntryId) {
            throw new DuplicateRemoteAppEntryURLException("{remoteAppEntryId=" + remoteAppEntryId + "}");
        }
    }
}

