/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.remote.app.uad.anonymizer;

import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.remote.app.model.RemoteAppEntry;
import com.liferay.remote.app.service.RemoteAppEntryLocalService;
import com.liferay.remote.app.uad.constants.RemoteAppUADConstants;
import com.liferay.user.associated.data.anonymizer.DynamicQueryUADAnonymizer;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseRemoteAppEntryUADAnonymizer
extends DynamicQueryUADAnonymizer<RemoteAppEntry> {
    @Reference
    protected RemoteAppEntryLocalService remoteAppEntryLocalService;

    public void autoAnonymize(RemoteAppEntry remoteAppEntry, long userId, User anonymousUser) throws PortalException {
        if (remoteAppEntry.getUserId() == userId) {
            remoteAppEntry.setUserId(anonymousUser.getUserId());
            remoteAppEntry.setUserName(anonymousUser.getFullName());
        }
        this.remoteAppEntryLocalService.updateRemoteAppEntry(remoteAppEntry);
    }

    public void delete(RemoteAppEntry remoteAppEntry) throws PortalException {
        this.remoteAppEntryLocalService.deleteRemoteAppEntry(remoteAppEntry);
    }

    public Class<RemoteAppEntry> getTypeClass() {
        return RemoteAppEntry.class;
    }

    protected ActionableDynamicQuery doGetActionableDynamicQuery() {
        return this.remoteAppEntryLocalService.getActionableDynamicQuery();
    }

    protected String[] doGetUserIdFieldNames() {
        return RemoteAppUADConstants.USER_ID_FIELD_NAMES_REMOTE_APP_ENTRY;
    }
}

