/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.roles.admin.internal.role.type.contributor;

import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.util.PropsValues;
import com.liferay.roles.admin.role.type.contributor.RoleTypeContributor;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"service.ranking:Integer=100"}, service={RoleTypeContributor.class})
public class RegularRoleTypeContributor
implements RoleTypeContributor {
    private static final String[] _AUTOMATICALLY_ASSIGNED_ROLE_NAMES = new String[]{"Guest", "Owner", "User"};
    @Reference
    private Portal _portal;

    public String getIcon() {
        return "user";
    }

    public String getName() {
        return "regular";
    }

    public String[] getSubtypes() {
        return PropsValues.ROLES_REGULAR_SUBTYPES;
    }

    public String getTabTitle(Locale locale) {
        return "regular-roles";
    }

    public String getTitle(Locale locale) {
        return "regular-role";
    }

    public int getType() {
        return 1;
    }

    public boolean isAllowAssignMembers(Role role) {
        return !ArrayUtil.contains((Object[])_AUTOMATICALLY_ASSIGNED_ROLE_NAMES, (Object)role.getName());
    }

    public boolean isAllowDefinePermissions(Role role) {
        String name = role.getName();
        return !name.equals("Administrator") && !name.equals("Analytics Administrator") && !name.equals("Owner");
    }

    public boolean isAllowDelete(Role role) {
        if (role == null) {
            return false;
        }
        return !this._portal.isSystemRole(role.getName());
    }

    public boolean isAutomaticallyAssigned(Role role) {
        return ArrayUtil.contains((Object[])_AUTOMATICALLY_ASSIGNED_ROLE_NAMES, (Object)role.getName());
    }
}

