/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.roles.admin.internal.role.type.contributor;

import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.util.PropsValues;
import com.liferay.roles.admin.role.type.contributor.RoleTypeContributor;
import java.util.Locale;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"service.ranking:Integer=300"}, service={RoleTypeContributor.class})
public class OrganizationRoleTypeContributor
implements RoleTypeContributor {
    @Reference
    private Portal _portal;

    public String[] getExcludedRoleNames() {
        return new String[]{"Organization Administrator", "Organization Owner"};
    }

    public String getIcon() {
        return "community";
    }

    public String getName() {
        return "organization";
    }

    public String[] getSubtypes() {
        return PropsValues.ROLES_ORGANIZATION_SUBTYPES;
    }

    public String getTabTitle(Locale locale) {
        return "organization-roles";
    }

    public String getTitle(Locale locale) {
        return "organization-role";
    }

    public int getType() {
        return 3;
    }

    public boolean isAllowAssignMembers(Role role) {
        return false;
    }

    public boolean isAllowDelete(Role role) {
        if (role == null) {
            return false;
        }
        return !this._portal.isSystemRole(role.getName());
    }

    public boolean isAutomaticallyAssigned(Role role) {
        return Objects.equals("Organization User", role.getName());
    }
}

