/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.roles.uad.anonymizer;

import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.RoleLocalService;

import com.liferay.roles.uad.constants.RolesUADConstants;

import com.liferay.user.associated.data.anonymizer.DynamicQueryUADAnonymizer;

import org.osgi.service.component.annotations.Reference;

/**
 * Provides the base implementation for the role UAD anonymizer.
 *
 * <p>
 * This implementation exists only as a container for the default methods
 * generated by ServiceBuilder. All custom service methods should be put in
 * {@link RoleUADAnonymizer}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @generated
 */
public abstract class BaseRoleUADAnonymizer extends DynamicQueryUADAnonymizer<Role> {
	@Override
	public void autoAnonymize(Role role, long userId, User anonymousUser)
		throws PortalException {
		if (role.getUserId() == userId) {
			role.setUserId(anonymousUser.getUserId());
			role.setUserName(anonymousUser.getFullName());
		}

		roleLocalService.updateRole(role);
	}

	@Override
	public void delete(Role role) throws PortalException {
		roleLocalService.deleteRole(role);
	}

	@Override
	public Class<Role> getTypeClass() {
		return Role.class;
	}

	@Override
	protected ActionableDynamicQuery doGetActionableDynamicQuery() {
		return roleLocalService.getActionableDynamicQuery();
	}

	@Override
	protected String[] doGetUserIdFieldNames() {
		return RolesUADConstants.USER_ID_FIELD_NAMES_ROLE;
	}

	@Reference
	protected RoleLocalService roleLocalService;
}