/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sass.compiler.ruby.internal;

import com.liferay.sass.compiler.SassCompiler;
import com.liferay.sass.compiler.ruby.internal.RubySassCompilerException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Scanner;
import org.jruby.RubyInstanceConfig;
import org.jruby.embed.LocalContextScope;
import org.jruby.embed.ScriptingContainer;
import org.jruby.embed.internal.LocalContextProvider;

public class RubySassCompiler
implements AutoCloseable,
SassCompiler {
    private static final String _COMPILE_MODE_FORCE = "force";
    private static final String _COMPILE_MODE_JIT = "jit";
    private static final int _COMPILE_THRESHOLD_DEFAULT = 5;
    private static final int _PRECISION_DEFAULT = 5;
    private final int _precision;
    private final ScriptingContainer _scriptingContainer;
    private final Object _scriptObject;
    private final String _tmpDirName;

    public RubySassCompiler() throws Exception {
        this(5);
    }

    public RubySassCompiler(int precision) throws Exception {
        this(_COMPILE_MODE_JIT, 5, precision, System.getProperty("java.io.tmpdir"));
    }

    public RubySassCompiler(String compileMode, int compilerThreshold, int precision, String tmpDirName) throws Exception {
        this._precision = precision;
        this._tmpDirName = tmpDirName;
        this._scriptingContainer = new ScriptingContainer(LocalContextScope.THREADSAFE);
        LocalContextProvider localContextProvider = this._scriptingContainer.getProvider();
        RubyInstanceConfig rubyInstanceConfig = localContextProvider.getRubyInstanceConfig();
        if (_COMPILE_MODE_FORCE.equals(compileMode)) {
            rubyInstanceConfig.setCompileMode(RubyInstanceConfig.CompileMode.FORCE);
        } else if (_COMPILE_MODE_JIT.equals(compileMode)) {
            rubyInstanceConfig.setCompileMode(RubyInstanceConfig.CompileMode.JIT);
        }
        ArrayList<String> loadPaths = new ArrayList<String>();
        loadPaths.add("META-INF/jruby.home/lib/ruby/stdlib");
        loadPaths.add("gems/ffi-1.11.1-java/lib");
        loadPaths.add("gems/rb-fsevent-0.10.3/lib");
        loadPaths.add("gems/rb-inotify-0.10.0/lib");
        loadPaths.add("gems/sass-3.5.5/lib");
        loadPaths.add("gems/sass-listen-4.0.0/lib");
        rubyInstanceConfig.setLoadPaths(loadPaths);
        rubyInstanceConfig.setJitThreshold(compilerThreshold);
        String rubyScript = null;
        Class<?> clazz = this.getClass();
        try (InputStream inputStream = clazz.getResourceAsStream("dependencies/main.rb");){
            Scanner scanner = new Scanner(inputStream, "UTF-8");
            scanner.useDelimiter("\\A");
            rubyScript = scanner.next();
        }
        this._scriptObject = this._scriptingContainer.runScriptlet(rubyScript);
    }

    @Override
    public void close() {
        this._scriptingContainer.terminate();
    }

    public String compileFile(String inputFileName, String includeDirName) throws RubySassCompilerException {
        return this.compileFile(inputFileName, includeDirName, false, "");
    }

    public String compileFile(String inputFileName, String includeDirName, boolean generateSourceMap) throws RubySassCompilerException {
        return this.compileFile(inputFileName, includeDirName, generateSourceMap, "");
    }

    public String compileFile(String inputFileName, String includeDirName, boolean generateSourceMap, String sourceMapFileName) throws RubySassCompilerException {
        try {
            File inputFile = new File(inputFileName);
            String includeDirNames = includeDirName + File.pathSeparator + inputFile.getParent();
            String outputFileName = this._getOutputFileName(inputFileName);
            if (sourceMapFileName == null || sourceMapFileName.equals("")) {
                sourceMapFileName = outputFileName + ".map";
            }
            String[] results = (String[])this._scriptingContainer.callMethod(this._scriptObject, "process", new Object[]{inputFileName, includeDirNames, this._tmpDirName, false, outputFileName, this._precision, generateSourceMap, sourceMapFileName}, String[].class);
            if (generateSourceMap) {
                try {
                    this._write(new File(sourceMapFileName), results[1]);
                }
                catch (Exception e) {
                    System.out.println("Unable to create source map");
                }
            }
            return results[0];
        }
        catch (Exception e) {
            throw new RubySassCompilerException("Unable to parse " + inputFileName, e);
        }
    }

    public String compileString(String input, String includeDirName) throws RubySassCompilerException {
        return this.compileString(input, "", includeDirName, false);
    }

    public String compileString(String input, String inputFileName, String includeDirName, boolean generateSourceMap) throws RubySassCompilerException {
        return this.compileString(input, inputFileName, includeDirName, generateSourceMap, "");
    }

    public String compileString(String input, String inputFileName, String includeDirName, boolean generateSourceMap, String sourceMapFileName) throws RubySassCompilerException {
        try {
            int index;
            if (inputFileName == null || inputFileName.equals("")) {
                inputFileName = this._tmpDirName + File.separator + "tmp.scss";
                if (generateSourceMap) {
                    System.out.println("Source maps require a valid fileName");
                    generateSourceMap = false;
                }
            }
            if ((index = inputFileName.lastIndexOf(File.separatorChar)) == -1 && File.separatorChar != '/') {
                index = inputFileName.lastIndexOf(47);
            }
            String path = inputFileName.substring(0, ++index);
            String fileName = inputFileName.substring(index);
            String outputFileName = this._getOutputFileName(fileName);
            if (sourceMapFileName == null || sourceMapFileName.equals("")) {
                sourceMapFileName = path + outputFileName + ".map";
            }
            File tempFile = new File(path, "tmp.scss");
            tempFile.deleteOnExit();
            this._write(tempFile, input);
            String output = this.compileFile(tempFile.getCanonicalPath(), includeDirName, generateSourceMap, sourceMapFileName);
            if (generateSourceMap) {
                File sourceMapFile = new File(sourceMapFileName);
                String sourceMapContent = new String(Files.readAllBytes(sourceMapFile.toPath()));
                sourceMapContent = sourceMapContent.replaceAll("tmp\\.scss", fileName);
                sourceMapContent = sourceMapContent.replaceAll("tmp\\.css", outputFileName);
                this._write(sourceMapFile, sourceMapContent);
            }
            return output;
        }
        catch (Exception e) {
            throw new RubySassCompilerException(e);
        }
    }

    private String _getOutputFileName(String fileName) {
        return fileName.replaceAll("scss$", "css");
    }

    private void _write(File file, String string) throws IOException {
        if (!file.exists()) {
            File parentFile = file.getParentFile();
            parentFile.mkdirs();
            file.createNewFile();
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file, false), "UTF-8");){
            writer.write(string);
        }
    }
}

