/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.content.targeting.upgrade.internal.v1_0_0;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.segments.content.targeting.upgrade.internal.v1_0_0.util.RuleConverter;
import com.liferay.segments.content.targeting.upgrade.internal.v1_0_0.util.RuleConverterRegistry;
import com.liferay.segments.criteria.Criteria;
import com.liferay.segments.criteria.CriteriaSerializer;
import com.liferay.segments.service.SegmentsEntryLocalService;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Map;

public class ContentTargetingUpgradeProcess
extends UpgradeProcess {
    private static final String _CT_PACKAGE_NAME = "com.liferay.content.targeting";
    private static final Log _log = LogFactoryUtil.getLog(ContentTargetingUpgradeProcess.class);
    private final RuleConverterRegistry _ruleConverterRegistry;
    private final SegmentsEntryLocalService _segmentsEntryLocalService;

    public ContentTargetingUpgradeProcess(RuleConverterRegistry ruleConverterRegistry, SegmentsEntryLocalService segmentsEntryLocalService) {
        this._ruleConverterRegistry = ruleConverterRegistry;
        this._segmentsEntryLocalService = segmentsEntryLocalService;
    }

    public void doUpgrade() throws Exception {
        if (!this.hasTable("CT_UserSegment")) {
            return;
        }
        this.upgradeContentTargetingUserSegments();
        this.deleteContentTargetingData();
    }

    protected void deleteContentTargetingData() throws Exception {
        this.runSQL("delete from ClassName_ where value like 'com.liferay.content.targeting%'");
        this.runSQL("delete from Release_ where servletContextName like 'com.liferay.content.targeting%'");
        this.runSQL("delete from ResourceAction where name like 'com.liferay.content.targeting%'");
        this.runSQL("delete from ResourcePermission where name like 'com.liferay.content.targeting%'");
        this.runSQL("delete from ServiceComponent where buildNamespace like 'CT%'");
        this._dropTable("CT_AU_AnonymousUser");
        this._dropTable("CT_Analytics_AnalyticsEvent");
        this._dropTable("CT_Analytics_AnalyticsReferrer");
        this._dropTable("CT_AnonymousUserUserSegment");
        this._dropTable("CT_CCR_CampaignContent");
        this._dropTable("CT_CTA_CTAction");
        this._dropTable("CT_CTA_CTActionTotal");
        this._dropTable("CT_Campaign");
        this._dropTable("CT_Campaigns_UserSegments");
        this._dropTable("CT_ChannelInstance");
        this._dropTable("CT_ReportInstance");
        this._dropTable("CT_RuleInstance");
        this._dropTable("CT_ScorePoints_ScorePoint");
        this._dropTable("CT_Tactic");
        this._dropTable("CT_Tactics_UserSegments");
        this._dropTable("CT_TrackingActionInstance");
        this._dropTable("CT_USCR_UserSegmentContent");
        this._dropTable("CT_UserSegment");
        this._dropTable("CT_Visited_ContentVisited");
        this._dropTable("CT_Visited_PageVisited");
    }

    protected String getCriteria(long userSegmentId) throws Exception {
        Criteria criteria = new Criteria();
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("select companyId, ruleKey, typeSettings from CT_RuleInstance where userSegmentId = ?");){
            preparedStatement.setLong(1, userSegmentId);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    String ruleKey = resultSet.getString("ruleKey");
                    RuleConverter ruleConverter = this._ruleConverterRegistry.getRuleConverter(ruleKey);
                    if (ruleConverter == null) {
                        if (!_log.isWarnEnabled()) continue;
                        _log.warn((Object)("Unable to perform automated update of rule " + ruleKey));
                        continue;
                    }
                    long companyId = resultSet.getLong("companyId");
                    String typeSettings = resultSet.getString("typeSettings");
                    ruleConverter.convert(companyId, criteria, typeSettings);
                }
            }
        }
        return CriteriaSerializer.serialize((Criteria)criteria);
    }

    protected void upgradeContentTargetingUserSegments() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement preparedStatement1 = this.connection.prepareStatement("select * from CT_UserSegment");
             ResultSet resultSet = preparedStatement1.executeQuery();){
            ServiceContext serviceContext = new ServiceContext();
            while (resultSet.next()) {
                long userSegmentId = resultSet.getLong("userSegmentId");
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Upgrading Content Targeting User Segment " + userSegmentId));
                }
                Map nameMap = LocalizationUtil.getLocalizationMap((String)resultSet.getString("name"));
                Map descriptionMap = LocalizationUtil.getLocalizationMap((String)resultSet.getString("description"));
                serviceContext.setScopeGroupId(resultSet.getLong("groupId"));
                serviceContext.setUserId(PortalUtil.getValidUserId((long)resultSet.getLong("companyId"), (long)resultSet.getLong("userId")));
                this._segmentsEntryLocalService.addSegmentsEntry("ct_" + userSegmentId, nameMap, descriptionMap, true, this.getCriteria(userSegmentId), "DEFAULT", User.class.getName(), serviceContext);
            }
        }
    }

    private void _dropTable(String tableName) throws Exception {
        if (this.hasTable(tableName)) {
            this.runSQL("drop table " + tableName);
        }
    }
}

