/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.context.vocabulary.internal.configuration.admin.definition;

import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.service.AssetVocabularyLocalService;
import com.liferay.configuration.admin.definition.ConfigurationFieldOptionsProvider;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.CompanyLocalService;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"configuration.field.name=assetVocabularyName", "configuration.pid=com.liferay.segments.context.vocabulary.internal.configuration.SegmentsContextVocabularyCompanyConfiguration", "configuration.pid=com.liferay.segments.context.vocabulary.internal.configuration.SegmentsContextVocabularyConfiguration"}, service={ConfigurationFieldOptionsProvider.class})
public class AssetVocabularyConfigurationFieldOptionsProvider
implements ConfigurationFieldOptionsProvider {
    private static final Log _log = LogFactoryUtil.getLog(AssetVocabularyConfigurationFieldOptionsProvider.class);
    @Reference
    private AssetVocabularyLocalService _assetVocabularyLocalService;
    @Reference
    private CompanyLocalService _companyLocalService;

    public List<ConfigurationFieldOptionsProvider.Option> getOptions() {
        try {
            Long companyId = CompanyThreadLocal.getCompanyId();
            if (companyId == null) {
                return Collections.emptyList();
            }
            Company company = this._companyLocalService.getCompany(companyId.longValue());
            List assetVocabularies = this._assetVocabularyLocalService.getGroupsVocabularies(new long[]{company.getGroupId()});
            Stream stream = assetVocabularies.stream();
            return stream.map(this::_toOption).sorted(Comparator.comparing(ConfigurationFieldOptionsProvider.Option::getValue)).collect(Collectors.toList());
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return Collections.emptyList();
        }
    }

    private ConfigurationFieldOptionsProvider.Option _toOption(final AssetVocabulary assetVocabulary) {
        return new ConfigurationFieldOptionsProvider.Option(){

            public String getLabel(Locale locale) {
                return assetVocabulary.getTitle(locale);
            }

            public String getValue() {
                return assetVocabulary.getName();
            }
        };
    }
}

