/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.context.vocabulary.internal.configuration.admin.definition;

import com.liferay.configuration.admin.definition.ConfigurationFieldOptionsProvider;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.util.CamelCaseUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.odata.entity.EntityField;
import com.liferay.portal.odata.entity.EntityModel;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"configuration.field.name=entityFieldName", "configuration.pid=com.liferay.segments.context.vocabulary.internal.configuration.SegmentsContextVocabularyCompanyConfiguration", "configuration.pid=com.liferay.segments.context.vocabulary.internal.configuration.SegmentsContextVocabularyConfiguration"}, service={ConfigurationFieldOptionsProvider.class})
public class EntityFieldConfigurationFieldOptionsProvider
implements ConfigurationFieldOptionsProvider {
    @Reference(target="(entity.model.name=Context)")
    private EntityModel _entityModel;
    @Reference
    private Language _language;
    private volatile List<ConfigurationFieldOptionsProvider.Option> _options;

    public List<ConfigurationFieldOptionsProvider.Option> getOptions() {
        return Optional.of(this._options).orElse(Collections.emptyList());
    }

    @Activate
    @Modified
    protected void activate() {
        Map entityFieldsMap = this._entityModel.getEntityFieldsMap();
        Set entries = entityFieldsMap.entrySet();
        Stream stream = entries.stream();
        this._options = stream.filter(entry -> {
            EntityField entityField = (EntityField)entry.getValue();
            return Objects.equals(entityField.getType(), EntityField.Type.STRING);
        }).map(Map.Entry::getKey).map(this::_toOption).sorted(Comparator.comparing(ConfigurationFieldOptionsProvider.Option::getValue)).collect(Collectors.toList());
    }

    @Deactivate
    protected void deactivate() {
        this._options = null;
    }

    private ConfigurationFieldOptionsProvider.Option _toOption(final String value) {
        return new ConfigurationFieldOptionsProvider.Option(){

            public String getLabel(Locale locale) {
                ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, this.getClass());
                return EntityFieldConfigurationFieldOptionsProvider.this._language.get(resourceBundle, "field." + CamelCaseUtil.fromCamelCase((String)value));
            }

            public String getValue() {
                return value;
            }
        };
    }
}

