/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.context.vocabulary.internal.configuration.admin.definition;

import com.liferay.configuration.admin.definition.ConfigurationFieldOptionsProvider;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.util.CamelCaseUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.odata.entity.EntityField;
import com.liferay.portal.odata.entity.EntityModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(property={"configuration.field.name=entityFieldName", "configuration.pid=com.liferay.segments.context.vocabulary.internal.configuration.SegmentsContextVocabularyCompanyConfiguration", "configuration.pid=com.liferay.segments.context.vocabulary.internal.configuration.SegmentsContextVocabularyConfiguration"}, service={ConfigurationFieldOptionsProvider.class})
public class EntityFieldConfigurationFieldOptionsProvider
implements ConfigurationFieldOptionsProvider {
    @Reference(target="(entity.model.name=Context)")
    private EntityModel _entityModel;
    @Reference
    private Language _language;
    private volatile List<ConfigurationFieldOptionsProvider.Option> _options;

    public List<ConfigurationFieldOptionsProvider.Option> getOptions() {
        return this._options;
    }

    @Activate
    @Modified
    protected void activate() {
        ArrayList<ConfigurationFieldOptionsProvider.Option> options = new ArrayList<ConfigurationFieldOptionsProvider.Option>();
        Map entityFieldsMap = this._entityModel.getEntityFieldsMap();
        for (EntityField entityField : entityFieldsMap.values()) {
            if (!Objects.equals(entityField.getType(), EntityField.Type.STRING)) continue;
            options.add(this._toOption(entityField.getName()));
        }
        Collections.sort(options, Comparator.comparing(ConfigurationFieldOptionsProvider.Option::getValue));
        this._options = options;
    }

    @Deactivate
    protected void deactivate() {
        this._options = Collections.emptyList();
    }

    private ConfigurationFieldOptionsProvider.Option _toOption(final String value) {
        return new ConfigurationFieldOptionsProvider.Option(){

            public String getLabel(Locale locale) {
                ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, this.getClass());
                return EntityFieldConfigurationFieldOptionsProvider.this._language.get(resourceBundle, "field." + CamelCaseUtil.fromCamelCase((String)value));
            }

            public String getValue() {
                return value;
            }
        };
    }
}

