/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.context.vocabulary.internal.configuration.persistence.listener;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.persistence.listener.ConfigurationModelListener;
import com.liferay.portal.configuration.persistence.listener.ConfigurationModelListenerException;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.segments.context.vocabulary.internal.configuration.persistence.listener.DuplicatedSegmentsContextVocabularyConfigurationModelListenerException;
import java.util.Dictionary;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseConfigurationModelListener
implements ConfigurationModelListener {
    @Reference
    protected ConfigurationAdmin configurationAdmin;

    public void onBeforeSave(String pid, Dictionary<String, Object> properties) throws ConfigurationModelListenerException {
        String entityFieldName = String.valueOf(properties.get("entityFieldName"));
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)LocaleThreadLocal.getThemeDisplayLocale(), this.getClass());
        if (Validator.isNull((String)entityFieldName)) {
            throw new ConfigurationModelListenerException(ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)"please-enter-a-valid-session-property-name"), this.getConfigurationClass(), this.getClass(), properties);
        }
        if (this._isDefined(String.valueOf(properties.get("assetVocabularyName")), String.valueOf(properties.get("companyId")), entityFieldName, pid)) {
            throw new DuplicatedSegmentsContextVocabularyConfigurationModelListenerException(ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)"this-field-is-already-linked-to-one-vocabulary"), this.getConfigurationClass(), this.getClass(), properties);
        }
    }

    protected abstract Class<?> getConfigurationClass();

    private boolean _isDefined(String assetVocabularyName, String companyId, String entityFieldName, String pid) throws ConfigurationModelListenerException {
        try {
            Configuration[] configurations = this.configurationAdmin.listConfigurations(StringBundler.concat((String[])new String[]{"(", "service.factoryPid", "=", this.getConfigurationClass().getCanonicalName(), ")"}));
            if (configurations == null) {
                return false;
            }
            for (Configuration configuration : configurations) {
                Dictionary properties = configuration.getProperties();
                if (!Objects.equals(entityFieldName, properties.get("entityFieldName")) || Objects.equals(pid, configuration.getPid()) || !Objects.equals(companyId, String.valueOf(properties.get("companyId"))) && !Objects.equals(assetVocabularyName, properties.get("assetVocabularyName"))) continue;
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            throw new ConfigurationModelListenerException(exception.getMessage(), this.getConfigurationClass(), this.getClass(), null);
        }
    }
}

