/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.context.vocabulary.internal.field.customizer;

import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.service.AssetVocabularyLocalService;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.CamelCaseUtil;
import com.liferay.segments.context.vocabulary.internal.configuration.SegmentsContextVocabularyConfiguration;
import com.liferay.segments.field.Field;
import com.liferay.segments.field.customizer.SegmentsFieldCustomizer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.segments.context.vocabulary.internal.configuration.SegmentsContextVocabularyConfiguration"}, configurationPolicy=ConfigurationPolicy.REQUIRE, property={"segments.field.customizer.entity.name=Context", "segments.field.customizer.key=assetVocabularyName", "segments.field.customizer.priority:Integer=-1"}, service={SegmentsFieldCustomizer.class})
public class SegmentsContextVocabularySegmentsFieldCustomizer
implements SegmentsFieldCustomizer {
    public static final String KEY = "assetVocabularyName";
    private static final Log _log = LogFactoryUtil.getLog(SegmentsContextVocabularySegmentsFieldCustomizer.class);
    private volatile String _assetVocabulary;
    @Reference
    private AssetVocabularyLocalService _assetVocabularyLocalService;
    private volatile String _entityField;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private Language _language;

    public List<String> getFieldNames() {
        return Collections.singletonList(this._entityField);
    }

    public String getFieldValueName(String fieldValue, Locale locale) {
        return fieldValue;
    }

    public String getKey() {
        return KEY;
    }

    public String getLabel(String fieldName, Locale locale) {
        return this._language.get(locale, "field." + CamelCaseUtil.fromCamelCase((String)fieldName));
    }

    public List<Field.Option> getOptions(Locale locale) {
        Long companyId = CompanyThreadLocal.getCompanyId();
        if (companyId == null) {
            return null;
        }
        String assetVocabulary = this._assetVocabulary;
        Group group = this._groupLocalService.fetchCompanyGroup(companyId.longValue());
        AssetVocabulary groupAssetVocabulary = this._assetVocabularyLocalService.fetchGroupVocabulary(group.getGroupId(), assetVocabulary);
        if (groupAssetVocabulary == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)StringBundler.concat((Object[])new Object[]{"No asset vocabulary was found with name ", assetVocabulary, " in company ", companyId}));
            }
            return Collections.emptyList();
        }
        return TransformUtil.transform((Collection)groupAssetVocabulary.getCategories(), assetCategory -> new Field.Option(assetCategory.getTitle(locale), assetCategory.getName()));
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        SegmentsContextVocabularyConfiguration segmentsContextVocabularyConfiguration = (SegmentsContextVocabularyConfiguration)ConfigurableUtil.createConfigurable(SegmentsContextVocabularyConfiguration.class, properties);
        this._entityField = segmentsContextVocabularyConfiguration.entityFieldName();
        this._assetVocabulary = segmentsContextVocabularyConfiguration.assetVocabularyName();
    }
}

