/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.item.selector.web.internal;

import com.liferay.item.selector.TableItemView;
import com.liferay.portal.kernel.dao.search.SearchEntry;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.segments.model.SegmentsEntry;
import com.liferay.taglib.search.DateSearchEntry;
import com.liferay.taglib.search.TextSearchEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class SegmentsEntryTableItemView
implements TableItemView {
    private static final Log _log = LogFactoryUtil.getLog(SegmentsEntryTableItemView.class);
    private final SegmentsEntry _segmentsEntry;
    private final ThemeDisplay _themeDisplay;

    public SegmentsEntryTableItemView(SegmentsEntry segmentsEntry, ThemeDisplay themeDisplay) {
        this._segmentsEntry = segmentsEntry;
        this._themeDisplay = themeDisplay;
    }

    public List<String> getHeaderNames() {
        return ListUtil.fromArray((Object[])new String[]{"title", "scope", "modified-date"});
    }

    public List<SearchEntry> getSearchEntries(Locale locale) {
        ArrayList<SearchEntry> searchEntries = new ArrayList<SearchEntry>();
        TextSearchEntry nameTextSearchEntry = new TextSearchEntry();
        nameTextSearchEntry.setCssClass("entry entry-selector table-cell-expand table-cell-minw-200");
        nameTextSearchEntry.setName(HtmlUtil.escape((String)this._segmentsEntry.getName(this._themeDisplay.getLocale())));
        searchEntries.add((SearchEntry)nameTextSearchEntry);
        TextSearchEntry scopeTextSearchEntry = new TextSearchEntry();
        scopeTextSearchEntry.setCssClass("table-cell-expand-smaller table-cell-minw-150");
        scopeTextSearchEntry.setName(LanguageUtil.get((Locale)locale, (String)HtmlUtil.escape((String)this._getGroupDescriptiveName())));
        searchEntries.add((SearchEntry)scopeTextSearchEntry);
        DateSearchEntry modifiedDateTextDateSearchEntry = new DateSearchEntry();
        modifiedDateTextDateSearchEntry.setCssClass("table-cell-expand-smallest table-cell-ws-nowrap");
        modifiedDateTextDateSearchEntry.setDate(this._segmentsEntry.getModifiedDate());
        searchEntries.add((SearchEntry)modifiedDateTextDateSearchEntry);
        return searchEntries;
    }

    private String _getGroupDescriptiveName() {
        try {
            Group group = GroupLocalServiceUtil.fetchGroup((long)this._segmentsEntry.getGroupId());
            return group.getDescriptiveName(this._themeDisplay.getLocale());
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
            return "";
        }
    }
}

