Liferay.Loader.define('segments-web$dnd-core@11.1.3/dist/esm/reducers/dirtyHandlerIds', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    import { BEGIN_DRAG, PUBLISH_DRAG_SOURCE, HOVER, END_DRAG, DROP } from '../actions/dragDrop';
    import { ADD_SOURCE, ADD_TARGET, REMOVE_SOURCE, REMOVE_TARGET } from '../actions/registry';
    import { areArraysEqual } from '../utils/equality';
    import { NONE, ALL } from '../utils/dirtiness';
    import { xor } from '../utils/js_utils';
    export function reduce() {
      arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : NONE;


      var action = arguments.length > 1 ? arguments[1] : undefined;

      switch (action.type) {
        case HOVER:
          break;

        case ADD_SOURCE:
        case ADD_TARGET:
        case REMOVE_TARGET:
        case REMOVE_SOURCE:
          return NONE;

        case BEGIN_DRAG:
        case PUBLISH_DRAG_SOURCE:
        case END_DRAG:
        case DROP:
        default:
          return ALL;
      }

      var _action$payload = action.payload,
          _action$payload$targe = _action$payload.targetIds,
          targetIds = _action$payload$targe === void 0 ? [] : _action$payload$targe,
          _action$payload$prevT = _action$payload.prevTargetIds,
          prevTargetIds = _action$payload$prevT === void 0 ? [] : _action$payload$prevT;
      var result = xor(targetIds, prevTargetIds);
      var didChange = result.length > 0 || !areArraysEqual(targetIds, prevTargetIds);

      if (!didChange) {
        return NONE;
      } // Check the target ids at the innermost position. If they are valid, add them
      // to the result


      var prevInnermostTargetId = prevTargetIds[prevTargetIds.length - 1];
      var innermostTargetId = targetIds[targetIds.length - 1];

      if (prevInnermostTargetId !== innermostTargetId) {
        if (prevInnermostTargetId) {
          result.push(prevInnermostTargetId);
        }

        if (innermostTargetId) {
          result.push(innermostTargetId);
        }
      }

      return result;
    }
  }
});
//# sourceMappingURL=dirtyHandlerIds.js.map