/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharing.notifications.internal.service;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceWrapper;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.UserNotificationEventLocalService;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.sharing.model.SharingEntry;
import com.liferay.sharing.notifications.internal.helper.SharingNotificationHelper;
import com.liferay.sharing.notifications.internal.util.SharingNotificationSubcriptionSender;
import com.liferay.sharing.security.permission.SharingEntryAction;
import com.liferay.sharing.service.SharingEntryLocalServiceWrapper;
import java.util.Collection;
import java.util.Date;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ServiceWrapper.class})
public class NotificationsSharingEntryLocalServiceWrapper
extends SharingEntryLocalServiceWrapper {
    private static final Log _log = LogFactoryUtil.getLog(NotificationsSharingEntryLocalServiceWrapper.class);
    @Reference
    private SharingNotificationHelper _sharingNotificationHelper;
    @Reference
    private UserLocalService _userLocalService;
    @Reference
    private UserNotificationEventLocalService _userNotificationEventLocalService;

    public SharingEntry addSharingEntry(long fromUserId, long toUserId, long classNameId, long classPK, long groupId, boolean shareable, Collection<SharingEntryAction> sharingEntryActions, Date expirationDate, ServiceContext serviceContext) throws PortalException {
        SharingEntry sharingEntry = super.addSharingEntry(fromUserId, toUserId, classNameId, classPK, groupId, shareable, sharingEntryActions, expirationDate, serviceContext);
        this._sendNotificationEvent(sharingEntry, 0, serviceContext);
        return sharingEntry;
    }

    public SharingEntry updateSharingEntry(long sharingEntryId, Collection<SharingEntryAction> sharingEntryActions, boolean shareable, Date expirationDate, ServiceContext serviceContext) throws PortalException {
        SharingEntry sharingEntry = super.updateSharingEntry(sharingEntryId, sharingEntryActions, shareable, expirationDate, serviceContext);
        this._sendNotificationEvent(sharingEntry, 1, serviceContext);
        return sharingEntry;
    }

    public SharingEntry updateSharingEntry(long userId, long sharingEntryId, Collection<SharingEntryAction> sharingEntryActions, boolean shareable, Date expirationDate, ServiceContext serviceContext) throws PortalException {
        SharingEntry sharingEntry = super.updateSharingEntry(userId, sharingEntryId, sharingEntryActions, shareable, expirationDate, serviceContext);
        this._sendNotificationEvent(sharingEntry, 1, serviceContext);
        return sharingEntry;
    }

    private void _sendNotificationEvent(SharingEntry sharingEntry, int notificationType, ServiceContext serviceContext) {
        try {
            User user = this._userLocalService.getUser(sharingEntry.getToUserId());
            SharingNotificationSubcriptionSender sharingNotificationSubcriptionSender = new SharingNotificationSubcriptionSender();
            sharingNotificationSubcriptionSender.setSubject(this._sharingNotificationHelper.getNotificationMessage(sharingEntry, user.getLocale()));
            String entryURL = this._sharingNotificationHelper.getNotificationURL(sharingEntry, (PortletRequest)serviceContext.getLiferayPortletRequest());
            sharingNotificationSubcriptionSender.setBody(this._sharingNotificationHelper.getNotificationEmailBody(sharingEntry, (PortletRequest)serviceContext.getLiferayPortletRequest()));
            sharingNotificationSubcriptionSender.setClassName(sharingEntry.getModelClassName());
            sharingNotificationSubcriptionSender.setClassPK(sharingEntry.getSharingEntryId());
            sharingNotificationSubcriptionSender.setCompanyId(user.getCompanyId());
            sharingNotificationSubcriptionSender.setCurrentUserId(serviceContext.getUserId());
            sharingNotificationSubcriptionSender.setEntryURL(entryURL);
            String fromName = PrefsPropsUtil.getString((long)user.getCompanyId(), (String)"admin.email.from.name");
            String fromAddress = PrefsPropsUtil.getString((long)user.getCompanyId(), (String)"admin.email.from.address");
            sharingNotificationSubcriptionSender.setFrom(fromAddress, fromName);
            sharingNotificationSubcriptionSender.setHtmlFormat(true);
            sharingNotificationSubcriptionSender.setMailId("sharing_entry", new Object[]{sharingEntry.getSharingEntryId()});
            sharingNotificationSubcriptionSender.setNotificationType(notificationType);
            sharingNotificationSubcriptionSender.setPortletId("com_liferay_sharing_web_portlet_SharingPortlet");
            sharingNotificationSubcriptionSender.setScopeGroupId(sharingEntry.getGroupId());
            sharingNotificationSubcriptionSender.setServiceContext(serviceContext);
            sharingNotificationSubcriptionSender.addRuntimeSubscribers(user.getEmailAddress(), user.getFullName());
            sharingNotificationSubcriptionSender.flushNotificationsAsync();
        }
        catch (Exception exception) {
            _log.error((Object)("Unable to send notification for sharing entry: " + sharingEntry.getSharingEntryId()), (Throwable)exception);
        }
    }
}

