/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharing.notifications.internal.helper;

import com.liferay.petra.io.unsync.UnsyncStringWriter;
import com.liferay.petra.portlet.url.builder.PortletURLBuilder;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoader;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.URLTemplateResource;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.sharing.interpreter.SharingEntryInterpreter;
import com.liferay.sharing.interpreter.SharingEntryInterpreterProvider;
import com.liferay.sharing.model.SharingEntry;
import com.liferay.sharing.security.permission.SharingEntryAction;
import com.liferay.sharing.service.SharingEntryLocalService;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={SharingNotificationHelper.class})
public class SharingNotificationHelper {
    @Reference(target="(bundle.symbolic.name=com.liferay.sharing.notifications)")
    private ResourceBundleLoader _resourceBundleLoader;
    @Reference
    private SharingEntryInterpreterProvider _sharingEntryInterpreterProvider;
    @Reference
    private SharingEntryLocalService _sharingEntryLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public String getNotificationEmailBody(SharingEntry sharingEntry, PortletRequest portletRequest) throws Exception {
        Class<?> clazz = this.getClass();
        String templateId = "/com/liferay/sharing/notifications/dependencies/sharing_entry_added_email_body.ftl";
        URLTemplateResource templateResource = new URLTemplateResource(templateId, clazz.getResource(templateId));
        Template template = TemplateManagerUtil.getTemplate((String)"ftl", (TemplateResource)templateResource, (boolean)false);
        User toUser = this._userLocalService.fetchUser(sharingEntry.getToUserId());
        ResourceBundle resourceBundle = this._resourceBundleLoader.loadResourceBundle(this._getLocale(toUser));
        template.put((Object)"actionTitle", (Object)this._getEmailActionTitle(sharingEntry, resourceBundle));
        template.put((Object)"content", (Object)this._getNotificationMessage(sharingEntry, resourceBundle.getLocale(), portletRequest));
        if (portletRequest != null) {
            template.put((Object)"sharingEntryURL", (Object)this.getNotificationURL(sharingEntry, portletRequest));
        }
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
        template.processTemplate((Writer)unsyncStringWriter);
        return unsyncStringWriter.toString();
    }

    public String getNotificationMessage(SharingEntry sharingEntry, Locale locale) throws PortalException {
        return this._getNotificationMessage(sharingEntry, locale, null);
    }

    public String getNotificationURL(SharingEntry sharingEntry, PortletRequest portletRequest) throws PortalException {
        if (portletRequest != null) {
            return PortletURLBuilder.create((PortletURL)PortletProviderUtil.getPortletURL((PortletRequest)portletRequest, (String)SharingEntry.class.getName(), (PortletProvider.Action)PortletProvider.Action.PREVIEW)).setParameter("classNameId", (Object)sharingEntry.getClassNameId()).setParameter("classPK", (Object)sharingEntry.getClassPK()).setParameter("sharingEntryId", (Object)sharingEntry.getSharingEntryId()).buildString();
        }
        return null;
    }

    private String _getActionName(SharingEntry sharingEntry, ResourceBundle resourceBundle) {
        if (sharingEntry.hasSharingPermission(SharingEntryAction.UPDATE)) {
            return ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)"updating");
        }
        if (sharingEntry.hasSharingPermission(SharingEntryAction.ADD_DISCUSSION)) {
            return ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)"commenting");
        }
        if (sharingEntry.hasSharingPermission(SharingEntryAction.VIEW)) {
            return ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)"viewing");
        }
        return ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)"nothing");
    }

    private String _getEmailActionTitle(SharingEntry sharingEntry, ResourceBundle resourceBundle) throws Exception {
        SharingEntryInterpreter sharingEntryInterpreter = this._getSharingEntryInterpreter(sharingEntry);
        if (sharingEntryInterpreter != null) {
            return ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)"view-x", (Object[])new Object[]{sharingEntryInterpreter.getAssetTypeTitle(sharingEntry, resourceBundle.getLocale())});
        }
        return ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)"view");
    }

    private String _getExpirationDateText(SharingEntry sharingEntry, Locale locale) {
        if (sharingEntry.getExpirationDate() == null) {
            return null;
        }
        DateFormat expirationDateFormat = DateFormatFactoryUtil.getDate((Locale)locale);
        return expirationDateFormat.format((Object)sharingEntry.getExpirationDate());
    }

    private String _getFromUserName(SharingEntry sharingEntry, ResourceBundle resourceBundle) {
        User user = this._userLocalService.fetchUser(sharingEntry.getUserId());
        return this._getUserName(user, resourceBundle);
    }

    private Locale _getLocale(User toUser) {
        if (toUser != null) {
            return toUser.getLocale();
        }
        return LocaleUtil.getDefault();
    }

    private String _getNotificationMessage(SharingEntry sharingEntry, Locale locale, PortletRequest portletRequest) throws PortalException {
        String languageKey = "x-has-shared-x-with-you-for-x";
        if (sharingEntry.getExpirationDate() != null) {
            languageKey = "x-has-shared-x-with-you-for-x-until-x";
        }
        ResourceBundle resourceBundle = this._resourceBundleLoader.loadResourceBundle(locale);
        return ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)languageKey, (Object[])new Object[]{this._getFromUserName(sharingEntry, resourceBundle), this._getSharingEntryObjectTitle(sharingEntry, resourceBundle, portletRequest), this._getActionName(sharingEntry, resourceBundle), this._getExpirationDateText(sharingEntry, locale)});
    }

    private SharingEntryInterpreter _getSharingEntryInterpreter(SharingEntry sharingEntry) {
        return this._sharingEntryInterpreterProvider.getSharingEntryInterpreter(sharingEntry);
    }

    private String _getSharingEntryObjectTitle(SharingEntry sharingEntry, ResourceBundle resourceBundle, PortletRequest portletRequest) throws PortalException {
        SharingEntryInterpreter sharingEntryInterpreter = this._getSharingEntryInterpreter(sharingEntry);
        String title = sharingEntryInterpreter != null ? sharingEntryInterpreter.getTitle(sharingEntry) : ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)"something");
        if (portletRequest != null) {
            return StringBundler.concat((String[])new String[]{"<a href=\"", this.getNotificationURL(sharingEntry, portletRequest), "\" style=\"color: #0b5fff; text-decoration: none;\">", HtmlUtil.escape((String)title), "</a>"});
        }
        return title;
    }

    private String _getUserName(User user, ResourceBundle resourceBundle) {
        if (user != null) {
            return HtmlUtil.escape((String)user.getFullName());
        }
        return ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)"someone");
    }
}

