/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharing.search.internal.permission;

import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.search.spi.model.permission.contributor.SearchPermissionFieldContributor;
import com.liferay.sharing.model.SharingEntry;
import com.liferay.sharing.service.SharingEntryLocalService;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={SearchPermissionFieldContributor.class})
public class SharingEntrySearchPermissionDocumentContributor
implements SearchPermissionFieldContributor {
    @Reference
    private Portal _portal;
    @Reference
    private SharingEntryLocalService _sharingEntryLocalService;

    public void contribute(Document document, String className, long classPK) {
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext != null && serviceContext.isStrictAdd()) {
            return;
        }
        List sharingEntries = this._sharingEntryLocalService.getSharingEntries(this._portal.getClassNameId(className), classPK);
        if (sharingEntries.isEmpty()) {
            return;
        }
        long[] userIds = new long[sharingEntries.size()];
        for (int i = 0; i < userIds.length; ++i) {
            SharingEntry sharingEntry = (SharingEntry)sharingEntries.get(i);
            userIds[i] = sharingEntry.getToUserId();
        }
        document.addKeyword("sharedToUserId", userIds);
    }
}

