/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharing.service.impl;

import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.sharing.model.SharingEntry;
import com.liferay.sharing.security.permission.SharingEntryAction;
import com.liferay.sharing.security.permission.SharingPermission;
import com.liferay.sharing.service.base.SharingEntryServiceBaseImpl;
import java.util.Collection;
import java.util.Date;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=sharing", "json.web.service.context.path=SharingEntry"}, service={AopService.class})
public class SharingEntryServiceImpl
extends SharingEntryServiceBaseImpl {
    @Reference
    protected SharingPermission sharingPermission;

    public SharingEntry addOrUpdateSharingEntry(long toUserId, long classNameId, long classPK, long groupId, boolean shareable, Collection<SharingEntryAction> sharingEntryActions, Date expirationDate, ServiceContext serviceContext) throws PortalException {
        SharingEntry sharingEntry = this.sharingEntryPersistence.fetchByTU_C_C(toUserId, classNameId, classPK);
        if (sharingEntry == null) {
            return this.sharingEntryService.addSharingEntry(toUserId, classNameId, classPK, groupId, shareable, sharingEntryActions, expirationDate, serviceContext);
        }
        return this.sharingEntryService.updateSharingEntry(sharingEntry.getSharingEntryId(), sharingEntryActions, shareable, expirationDate, serviceContext);
    }

    public SharingEntry addSharingEntry(long toUserId, long classNameId, long classPK, long groupId, boolean shareable, Collection<SharingEntryAction> sharingEntryActions, Date expirationDate, ServiceContext serviceContext) throws PortalException {
        this.sharingPermission.check(this.getPermissionChecker(), classNameId, classPK, groupId, sharingEntryActions);
        return this.sharingEntryLocalService.addSharingEntry(this.getUserId(), toUserId, classNameId, classPK, groupId, shareable, sharingEntryActions, expirationDate, serviceContext);
    }

    public SharingEntry deleteSharingEntry(long sharingEntryId, ServiceContext serviceContext) throws PortalException {
        SharingEntry sharingEntry = this.sharingEntryLocalService.getSharingEntry(sharingEntryId);
        this.sharingPermission.checkManageCollaboratorsPermission(this.getPermissionChecker(), sharingEntry.getClassNameId(), sharingEntry.getClassPK(), sharingEntry.getGroupId());
        return this.sharingEntryLocalService.deleteSharingEntry(sharingEntry);
    }

    public SharingEntry updateSharingEntry(long sharingEntryId, Collection<SharingEntryAction> sharingEntryActions, boolean shareable, Date expirationDate, ServiceContext serviceContext) throws PortalException {
        SharingEntry sharingEntry = this.sharingEntryPersistence.findByPrimaryKey(sharingEntryId);
        this.sharingPermission.checkManageCollaboratorsPermission(this.getPermissionChecker(), sharingEntry.getClassNameId(), sharingEntry.getClassPK(), sharingEntry.getGroupId());
        return this.sharingEntryLocalService.updateSharingEntry(this.getUserId(), sharingEntryId, sharingEntryActions, shareable, expirationDate, serviceContext);
    }
}

