/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharing.service.base;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.exportimport.kernel.lar.ExportImportHelperUtil;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.ParamSetter;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdate;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdateFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.sharing.model.SharingEntry;
import com.liferay.sharing.service.SharingEntryLocalService;
import com.liferay.sharing.service.SharingEntryLocalServiceUtil;
import com.liferay.sharing.service.persistence.SharingEntryFinder;
import com.liferay.sharing.service.persistence.SharingEntryPersistence;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.List;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

public abstract class SharingEntryLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements AopService,
IdentifiableOSGiService,
SharingEntryLocalService {
    protected SharingEntryLocalService sharingEntryLocalService;
    @Reference
    protected SharingEntryPersistence sharingEntryPersistence;
    @Reference
    protected SharingEntryFinder sharingEntryFinder;
    @Reference
    protected CounterLocalService counterLocalService;

    @Indexable(type=IndexableType.REINDEX)
    public SharingEntry addSharingEntry(SharingEntry sharingEntry) {
        sharingEntry.setNew(true);
        return (SharingEntry)this.sharingEntryPersistence.update((BaseModel)sharingEntry);
    }

    @Transactional(enabled=false)
    public SharingEntry createSharingEntry(long sharingEntryId) {
        return this.sharingEntryPersistence.create(sharingEntryId);
    }

    @Indexable(type=IndexableType.DELETE)
    public SharingEntry deleteSharingEntry(long sharingEntryId) throws PortalException {
        return this.sharingEntryPersistence.remove(sharingEntryId);
    }

    @Indexable(type=IndexableType.DELETE)
    public SharingEntry deleteSharingEntry(SharingEntry sharingEntry) {
        return (SharingEntry)this.sharingEntryPersistence.remove((BaseModel)sharingEntry);
    }

    public <T> T dslQuery(DSLQuery dslQuery) {
        return (T)this.sharingEntryPersistence.dslQuery(dslQuery);
    }

    public int dslQueryCount(DSLQuery dslQuery) {
        Long count = (Long)this.dslQuery(dslQuery);
        return count.intValue();
    }

    public DynamicQuery dynamicQuery() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return DynamicQueryFactoryUtil.forClass(SharingEntry.class, (ClassLoader)clazz.getClassLoader());
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.sharingEntryPersistence.findWithDynamicQuery(dynamicQuery);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.sharingEntryPersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.sharingEntryPersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.sharingEntryPersistence.countWithDynamicQuery(dynamicQuery);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.sharingEntryPersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    public SharingEntry fetchSharingEntry(long sharingEntryId) {
        return this.sharingEntryPersistence.fetchByPrimaryKey(sharingEntryId);
    }

    public SharingEntry fetchSharingEntryByUuidAndGroupId(String uuid, long groupId) {
        return this.sharingEntryPersistence.fetchByUUID_G(uuid, groupId);
    }

    public SharingEntry getSharingEntry(long sharingEntryId) throws PortalException {
        return this.sharingEntryPersistence.findByPrimaryKey(sharingEntryId);
    }

    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.sharingEntryLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(SharingEntry.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("sharingEntryId");
        return actionableDynamicQuery;
    }

    public IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = new IndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setBaseLocalService((BaseLocalService)this.sharingEntryLocalService);
        indexableActionableDynamicQuery.setClassLoader(this.getClassLoader());
        indexableActionableDynamicQuery.setModelClass(SharingEntry.class);
        indexableActionableDynamicQuery.setPrimaryKeyPropertyName("sharingEntryId");
        return indexableActionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.sharingEntryLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(SharingEntry.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("sharingEntryId");
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(final PortletDataContext portletDataContext) {
        final ExportActionableDynamicQuery exportActionableDynamicQuery = new ExportActionableDynamicQuery(){

            public long performCount() throws PortalException {
                ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
                StagedModelType stagedModelType = this.getStagedModelType();
                long modelAdditionCount = super.performCount();
                manifestSummary.addModelAdditionCount(stagedModelType, modelAdditionCount);
                long modelDeletionCount = ExportImportHelperUtil.getModelDeletionCount((PortletDataContext)portletDataContext, (StagedModelType)stagedModelType);
                manifestSummary.addModelDeletionCount(stagedModelType, modelDeletionCount);
                return modelAdditionCount;
            }
        };
        this.initActionableDynamicQuery((ActionableDynamicQuery)exportActionableDynamicQuery);
        exportActionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                portletDataContext.addDateRangeCriteria(dynamicQuery, "modifiedDate");
                StagedModelType stagedModelType = exportActionableDynamicQuery.getStagedModelType();
                long referrerClassNameId = stagedModelType.getReferrerClassNameId();
                Property classNameIdProperty = PropertyFactoryUtil.forName((String)"classNameId");
                if (referrerClassNameId != -1L && referrerClassNameId != -2L) {
                    dynamicQuery.add(classNameIdProperty.eq((Object)stagedModelType.getReferrerClassNameId()));
                } else if (referrerClassNameId == -2L) {
                    dynamicQuery.add(classNameIdProperty.isNotNull());
                }
            }
        });
        exportActionableDynamicQuery.setCompanyId(portletDataContext.getCompanyId());
        exportActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<SharingEntry>(){

            public void performAction(SharingEntry sharingEntry) throws PortalException {
                StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)sharingEntry);
            }
        });
        exportActionableDynamicQuery.setStagedModelType(new StagedModelType(PortalUtil.getClassNameId((String)SharingEntry.class.getName()), -1L));
        return exportActionableDynamicQuery;
    }

    public PersistedModel createPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return this.sharingEntryPersistence.create(((Long)primaryKeyObj).longValue());
    }

    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        return this.sharingEntryLocalService.deleteSharingEntry((SharingEntry)persistedModel);
    }

    public BasePersistence<SharingEntry> getBasePersistence() {
        return this.sharingEntryPersistence;
    }

    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.sharingEntryPersistence.findByPrimaryKey(primaryKeyObj);
    }

    public List<SharingEntry> getSharingEntriesByUuidAndCompanyId(String uuid, long companyId) {
        return this.sharingEntryPersistence.findByUuid_C(uuid, companyId);
    }

    public List<SharingEntry> getSharingEntriesByUuidAndCompanyId(String uuid, long companyId, int start, int end, OrderByComparator<SharingEntry> orderByComparator) {
        return this.sharingEntryPersistence.findByUuid_C(uuid, companyId, start, end, orderByComparator);
    }

    public SharingEntry getSharingEntryByUuidAndGroupId(String uuid, long groupId) throws PortalException {
        return this.sharingEntryPersistence.findByUUID_G(uuid, groupId);
    }

    public List<SharingEntry> getSharingEntries(int start, int end) {
        return this.sharingEntryPersistence.findAll(start, end);
    }

    public int getSharingEntriesCount() {
        return this.sharingEntryPersistence.countAll();
    }

    @Indexable(type=IndexableType.REINDEX)
    public SharingEntry updateSharingEntry(SharingEntry sharingEntry) {
        return (SharingEntry)this.sharingEntryPersistence.update((BaseModel)sharingEntry);
    }

    @Deactivate
    protected void deactivate() {
        this._setLocalServiceUtilService(null);
    }

    public Class<?>[] getAopInterfaces() {
        return new Class[]{SharingEntryLocalService.class, IdentifiableOSGiService.class, PersistedModelLocalService.class};
    }

    public void setAopProxy(Object aopProxy) {
        this.sharingEntryLocalService = (SharingEntryLocalService)aopProxy;
        this._setLocalServiceUtilService(this.sharingEntryLocalService);
    }

    public String getOSGiServiceIdentifier() {
        return SharingEntryLocalService.class.getName();
    }

    protected Class<?> getModelClass() {
        return SharingEntry.class;
    }

    protected String getModelClassName() {
        return SharingEntry.class.getName();
    }

    protected void runSQL(String sql) {
        try {
            DataSource dataSource = this.sharingEntryPersistence.getDataSource();
            DB db = DBManagerUtil.getDB();
            sql = db.buildSQL(sql);
            sql = PortalUtil.transformSQL((String)sql);
            SqlUpdate sqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate((DataSource)dataSource, (String)sql, (ParamSetter[])new ParamSetter[0]);
            sqlUpdate.update(new Object[0]);
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    private void _setLocalServiceUtilService(SharingEntryLocalService sharingEntryLocalService) {
        try {
            Field field = SharingEntryLocalServiceUtil.class.getDeclaredField("_service");
            field.setAccessible(true);
            field.set(null, sharingEntryLocalService);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }
}

