/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.sharing.web.internal.item.selector;

import com.liferay.item.selector.BaseItemSelectorCriterionHandler;
import com.liferay.item.selector.ItemSelectorCriterionHandler;

import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;

/**
 * @author Alejandro Tardín
 */
@Component(service = ItemSelectorCriterionHandler.class)
public class SharedAssetsFilterItemItemSelectorCriterionHandler
	extends BaseItemSelectorCriterionHandler
		<SharedAssetsFilterItemItemSelectorCriterion> {

	@Override
	public Class<SharedAssetsFilterItemItemSelectorCriterion>
		getItemSelectorCriterionClass() {

		return SharedAssetsFilterItemItemSelectorCriterion.class;
	}

	@Activate
	@Override
	protected void activate(BundleContext bundleContext) {
		super.activate(bundleContext);
	}

}