/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.shielded.container.internal.proxy;

import com.liferay.shielded.container.internal.proxy.FilterConfigDelegate;
import com.liferay.shielded.container.internal.proxy.ProxyFactory;
import java.io.IOException;
import java.util.function.Supplier;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class FilterWrapper
implements Filter {
    private final ClassLoader _classLoader;
    private final Supplier<? extends Filter> _filterSupplier;
    private final ProxyFactory _proxyFactory;
    private final ServletContext _servletContext;

    public FilterWrapper(ProxyFactory proxyFactory, Supplier<? extends Filter> filterSupplier, ServletContext servletContext) {
        this._proxyFactory = proxyFactory;
        this._filterSupplier = filterSupplier;
        this._servletContext = servletContext;
        this._classLoader = servletContext.getClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(this._classLoader);
        try {
            Filter filter = this._filterSupplier.get();
            filter.destroy();
        }
        finally {
            currentThread.setContextClassLoader(contextClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(this._classLoader);
        try {
            Filter filter = this._filterSupplier.get();
            filter.doFilter(servletRequest, servletResponse, filterChain);
        }
        finally {
            currentThread.setContextClassLoader(contextClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(FilterConfig filterConfig) throws ServletException {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(this._classLoader);
        try {
            Filter filter = this._filterSupplier.get();
            filter.init(this._proxyFactory.createASMWrapper(this._classLoader, FilterConfig.class, new FilterConfigDelegate(this._servletContext), filterConfig));
        }
        finally {
            currentThread.setContextClassLoader(contextClassLoader);
        }
    }
}

