/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.provider;

import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.LinkedHashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.site.search.GroupSearch;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.portlet.PortletRequest;

public class GroupSearchProvider {
    public static void setResultsAndTotal(List<String> classNames, long[] excludedGroupIds, GroupSearch groupSearch, PortletRequest portletRequest) throws PortalException {
        long parentGroupId = GroupSearchProvider._getParentGroupId(portletRequest);
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (!GroupSearchProvider._isSearch(portletRequest) && GroupSearchProvider._isFilterManageableGroups(portletRequest) && parentGroupId <= 0L) {
            groupSearch.setResultsAndTotal(ListUtil.sort(GroupSearchProvider._getAllGroups(classNames, portletRequest), (Comparator)groupSearch.getOrderByComparator()));
        } else if (GroupSearchProvider._isSearch(portletRequest)) {
            long[] classNameIds = TransformUtil.transformToLongArray(classNames, PortalUtil::getClassNameId);
            groupSearch.setResultsAndTotal(() -> GroupLocalServiceUtil.search((long)themeDisplay.getCompanyId(), (long[])classNameIds, (String)GroupSearchProvider._getKeywords(portletRequest), GroupSearchProvider._getGroupParams(classNames, excludedGroupIds, portletRequest, parentGroupId), (int)groupSearch.getStart(), (int)groupSearch.getEnd(), (OrderByComparator)groupSearch.getOrderByComparator()), GroupLocalServiceUtil.searchCount((long)themeDisplay.getCompanyId(), (long[])classNameIds, (String)GroupSearchProvider._getKeywords(portletRequest), GroupSearchProvider._getGroupParams(classNames, excludedGroupIds, portletRequest, parentGroupId)));
        } else {
            long[] classNameIds = TransformUtil.transformToLongArray(classNames, PortalUtil::getClassNameId);
            long groupId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"groupId", (long)0L);
            groupSearch.setResultsAndTotal(() -> GroupLocalServiceUtil.search((long)themeDisplay.getCompanyId(), (long[])classNameIds, (long)groupId, (String)GroupSearchProvider._getKeywords(portletRequest), GroupSearchProvider._getGroupParams(classNames, excludedGroupIds, portletRequest, parentGroupId), (int)groupSearch.getStart(), (int)groupSearch.getEnd(), (OrderByComparator)groupSearch.getOrderByComparator()), GroupLocalServiceUtil.searchCount((long)themeDisplay.getCompanyId(), (long[])classNameIds, (long)groupId, (String)GroupSearchProvider._getKeywords(portletRequest), GroupSearchProvider._getGroupParams(classNames, excludedGroupIds, portletRequest, parentGroupId)));
        }
    }

    private static List<Group> _getAllGroups(List<String> classNames, PortletRequest portletRequest) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        User user = themeDisplay.getUser();
        List groups = user.getMySiteGroups(ArrayUtil.toStringArray(classNames), -1);
        long groupId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"groupId", (long)0L);
        if (groupId != 0L) {
            groups.clear();
            groups.add(GroupLocalServiceUtil.getGroup((long)groupId));
        }
        return groups;
    }

    private static LinkedHashMap<String, Object> _getGroupParams(List<String> classNames, long[] excludedGroupIds, PortletRequest portletRequest, long parentGroupId) throws PortalException {
        LinkedHashMap groupParams = LinkedHashMapBuilder.put((Object)"actionId", (Object)"VIEW").put((Object)"excludedGroupIds", (Object)ListUtil.fromArray((long[])excludedGroupIds)).put((Object)"site", (Object)Boolean.TRUE).build();
        if (GroupSearchProvider._isSearch(portletRequest)) {
            if (GroupSearchProvider._isFilterManageableGroups(portletRequest)) {
                groupParams.put("groupsTree", GroupSearchProvider._getAllGroups(classNames, portletRequest));
            } else if (parentGroupId > 0L) {
                List groupsTree = ListUtil.fromArray((Object[])new Group[]{GroupLocalServiceUtil.getGroup((long)parentGroupId)});
                groupParams.put("groupsTree", groupsTree);
            }
            ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
            if (!permissionChecker.isCompanyAdmin() && !GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (String)"VIEW")) {
                User user = themeDisplay.getUser();
                groupParams.put("usersGroups", user.getUserId());
            }
        }
        return groupParams;
    }

    private static String _getKeywords(PortletRequest portletRequest) {
        return ParamUtil.getString((PortletRequest)portletRequest, (String)"keywords");
    }

    private static long _getParentGroupId(PortletRequest portletRequest) {
        Group group = null;
        long groupId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"groupId", (long)0L);
        if (groupId > 0L) {
            group = GroupLocalServiceUtil.fetchGroup((long)groupId);
        }
        if (group != null) {
            return group.getGroupId();
        }
        if (GroupSearchProvider._isFilterManageableGroups(portletRequest)) {
            return -1L;
        }
        return 0L;
    }

    private static boolean _isFilterManageableGroups(PortletRequest portletRequest) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        return !permissionChecker.isCompanyAdmin() && !GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (String)"VIEW");
    }

    private static boolean _isSearch(PortletRequest portletRequest) {
        return Validator.isNotNull((String)GroupSearchProvider._getKeywords(portletRequest));
    }
}

