/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.internal.exportimport.data.handler;

import com.liferay.exportimport.controller.PortletExportController;
import com.liferay.exportimport.controller.PortletImportController;
import com.liferay.exportimport.data.handler.base.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportHelper;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataContextFactory;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.PortletDataHandler;
import com.liferay.exportimport.kernel.lar.PortletDataHandlerStatusMessageSender;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lifecycle.ExportImportLifecycleManager;
import com.liferay.exportimport.lar.PermissionImporter;
import com.liferay.exportimport.staged.model.repository.StagedModelRepository;
import com.liferay.layout.set.model.adapter.StagedLayoutSet;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskThreadLocal;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.site.internal.exportimport.staged.model.repository.StagedGroupStagedModelRepositoryUtil;
import com.liferay.site.model.adapter.StagedGroup;
import com.liferay.sites.kernel.util.Sites;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={StagedModelDataHandler.class})
public class StagedGroupStagedModelDataHandler
extends BaseStagedModelDataHandler<StagedGroup> {
    public static final String[] CLASS_NAMES = new String[]{StagedGroup.class.getName()};
    private static final Log _log = LogFactoryUtil.getLog(StagedGroupStagedModelDataHandler.class);
    @Reference
    private ExportImportHelper _exportImportHelper;
    @Reference
    private ExportImportLifecycleManager _exportImportLifecycleManager;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private PermissionImporter _permissionImporter;
    @Reference
    private PortletDataContextFactory _portletDataContextFactory;
    @Reference
    private PortletDataHandlerStatusMessageSender _portletDataHandlerStatusMessageSender;
    @Reference
    private PortletExportController _portletExportController;
    @Reference
    private PortletImportController _portletImportController;
    @Reference
    private PortletLocalService _portletLocalService;
    @Reference
    private Sites _sites;
    @Reference(target="(model.class.name=com.liferay.site.model.adapter.StagedGroup)")
    private StagedModelRepository<StagedGroup> _stagedGroupStagedModelRepository;

    public void deleteStagedModel(StagedGroup stagedGroup) {
        throw new UnsupportedOperationException();
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) {
        throw new UnsupportedOperationException();
    }

    public List<StagedGroup> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return Collections.emptyList();
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(StagedGroup stagedGroup) {
        Group group = stagedGroup.getGroup();
        return group.getName();
    }

    public boolean validateReference(PortletDataContext portletDataContext, Element referenceElement) {
        Map groupIds = portletDataContext.getNewPrimaryKeysMap(Group.class);
        long groupId = GetterUtil.getLong((String)referenceElement.attributeValue("group-id"));
        if (groupId == 0L || groupIds.containsKey(groupId)) {
            return true;
        }
        Group existingGroup = StagedGroupStagedModelRepositoryUtil.fetchExistingGroup(portletDataContext, referenceElement);
        if (existingGroup == null) {
            return false;
        }
        groupIds.put(groupId, existingGroup.getGroupId());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExportStagedModel(PortletDataContext portletDataContext, StagedGroup stagedGroup) throws Exception {
        Group group = stagedGroup.getGroup();
        Set<String> dataSiteLevelPortletIds = this._checkDataSiteLevelPortlets(portletDataContext, group);
        if (BackgroundTaskThreadLocal.hasBackgroundTask()) {
            ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
            this._portletDataHandlerStatusMessageSender.sendStatusMessage("layout", ArrayUtil.toStringArray(dataSiteLevelPortletIds), manifestSummary);
            manifestSummary.resetCounters();
        }
        long[] layoutIds = portletDataContext.getLayoutIds();
        if (group.isLayoutPrototype()) {
            layoutIds = this._exportImportHelper.getAllLayoutIds(group.getGroupId(), portletDataContext.isPrivateLayout());
        }
        long previousScopeGroupId = portletDataContext.getScopeGroupId();
        try {
            this._exportSitePortlets(portletDataContext, stagedGroup, dataSiteLevelPortletIds, layoutIds);
        }
        finally {
            portletDataContext.setScopeGroupId(previousScopeGroupId);
        }
        List<StagedModel> childStagedModels = StagedGroupStagedModelRepositoryUtil.fetchChildrenStagedModels(portletDataContext, stagedGroup);
        for (StagedModel stagedModel : childStagedModels) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)stagedGroup, (StagedModel)stagedModel, (String)"child");
        }
        Element groupElement = portletDataContext.getExportDataElement((ClassedModel)stagedGroup);
        portletDataContext.addClassedModel(groupElement, ExportImportPathUtil.getModelPath((StagedModel)stagedGroup), (ClassedModel)stagedGroup);
    }

    protected void doImportMissingReference(PortletDataContext portletDataContext, Element referenceElement) {
        Map groupIds = portletDataContext.getNewPrimaryKeysMap(Group.class);
        long groupId = GetterUtil.getLong((String)referenceElement.attributeValue("group-id"));
        if (groupId == 0L || groupIds.containsKey(groupId)) {
            return;
        }
        Group existingGroup = StagedGroupStagedModelRepositoryUtil.fetchExistingGroup(portletDataContext, referenceElement);
        if (existingGroup == null) {
            return;
        }
        groupIds.put(groupId, existingGroup.getGroupId());
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, StagedGroup stagedGroup) throws Exception {
        Element rootElement = portletDataContext.getImportDataRootElement();
        Element sitePortletsElement = rootElement.element("site-portlets");
        List sitePortletElements = sitePortletsElement.elements();
        if (BackgroundTaskThreadLocal.hasBackgroundTask()) {
            ArrayList<String> portletIds = new ArrayList<String>();
            for (Element portletElement : sitePortletElements) {
                String portletId = portletElement.attributeValue("portlet-id");
                Portlet portlet = this._portletLocalService.getPortletById(portletDataContext.getCompanyId(), portletId);
                if (!portlet.isActive() || portlet.isUndeployedPortlet()) continue;
                portletIds.add(portletId);
            }
            this._portletDataHandlerStatusMessageSender.sendStatusMessage("layout", ArrayUtil.toStringArray(portletIds), portletDataContext.getManifestSummary());
        }
        if (_log.isDebugEnabled() && !sitePortletElements.isEmpty()) {
            _log.debug((Object)"Importing portlets");
        }
        this._importSitePortlets(portletDataContext, sitePortletElements);
        Element siteServicesElement = rootElement.element("site-services");
        List siteServiceElements = siteServicesElement.elements("service");
        if (_log.isDebugEnabled() && !siteServiceElements.isEmpty()) {
            _log.debug((Object)"Importing services");
        }
        this._importSiteServices(portletDataContext, siteServiceElements);
        Element layoutSetElement = portletDataContext.getImportDataGroupElement(StagedLayoutSet.class);
        for (Element groupElement : layoutSetElement.elements()) {
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)groupElement);
        }
    }

    protected StagedModelRepository<StagedGroup> getStagedModelRepository() {
        return this._stagedGroupStagedModelRepository;
    }

    protected void importReferenceStagedModels(PortletDataContext portletDataContext, StagedGroup stagedModel) throws PortletDataException {
    }

    private Set<String> _checkDataSiteLevelPortlets(PortletDataContext portletDataContext, Group group) throws Exception {
        List dataSiteLevelPortlets = this._exportImportHelper.getDataSiteLevelPortlets(portletDataContext.getCompanyId());
        Group liveGroup = group;
        if (liveGroup.isStagingGroup()) {
            liveGroup = liveGroup.getLiveGroup();
        }
        LinkedHashSet<String> portletIds = new LinkedHashSet<String>();
        for (Portlet portlet : dataSiteLevelPortlets) {
            Map exportPortletControlsMap;
            String portletId = portlet.getRootPortletId();
            if (ExportImportThreadLocal.isStagingInProcess() && !liveGroup.isStagedPortlet(portletId)) continue;
            if (BackgroundTaskThreadLocal.hasBackgroundTask() && ((Boolean)(exportPortletControlsMap = this._exportImportHelper.getExportPortletControlsMap(portletDataContext.getCompanyId(), portletId, portletDataContext.getParameterMap(), portletDataContext.getType())).get("PORTLET_DATA")).booleanValue()) {
                PortletDataHandler portletDataHandler = portlet.getPortletDataHandlerInstance();
                portletDataHandler.prepareManifestSummary(portletDataContext);
            }
            portletIds.add(portletId);
        }
        return portletIds;
    }

    private void _exportPortlet(PortletDataContext portletDataContext, String portletId, long plid, long scopeGroupId, String scopeType, String scopeLayoutUuid, String type, Element portletsElement, Element servicesElement, boolean permissions) throws Exception {
        portletDataContext.setPlid(plid);
        portletDataContext.setPortletId(portletId);
        portletDataContext.setScopeGroupId(scopeGroupId);
        portletDataContext.setScopeType(scopeType);
        portletDataContext.setScopeLayoutUuid(scopeLayoutUuid);
        Map exportPortletControlsMap = this._exportImportHelper.getExportPortletControlsMap(portletDataContext.getCompanyId(), portletId, portletDataContext.getParameterMap(), type);
        try {
            this._exportImportLifecycleManager.fireExportImportLifecycleEvent(9, this.getProcessFlag(), portletDataContext.getExportImportProcessId(), new Serializable[]{this._portletDataContextFactory.clonePortletDataContext(portletDataContext)});
            this._portletExportController.exportPortlet(portletDataContext, plid, portletsElement, permissions, ((Boolean)exportPortletControlsMap.get("PORTLET_ARCHIVED_SETUPS")).booleanValue(), ((Boolean)exportPortletControlsMap.get("PORTLET_DATA")).booleanValue(), ((Boolean)exportPortletControlsMap.get("PORTLET_SETUP")).booleanValue(), ((Boolean)exportPortletControlsMap.get("PORTLET_USER_PREFERENCES")).booleanValue());
            this._portletExportController.exportService(portletDataContext, servicesElement, ((Boolean)exportPortletControlsMap.get("PORTLET_SETUP")).booleanValue());
            this._exportImportLifecycleManager.fireExportImportLifecycleEvent(8, this.getProcessFlag(), portletDataContext.getExportImportProcessId(), new Serializable[]{this._portletDataContextFactory.clonePortletDataContext(portletDataContext)});
        }
        catch (Throwable throwable) {
            this._exportImportLifecycleManager.fireExportImportLifecycleEvent(7, this.getProcessFlag(), portletDataContext.getExportImportProcessId(), new Serializable[]{this._portletDataContextFactory.clonePortletDataContext(portletDataContext), throwable});
            throw throwable;
        }
    }

    private void _exportSitePortlets(PortletDataContext portletDataContext, StagedGroup stagedGroup, Set<String> portletIds, long[] layoutIds) throws Exception {
        Element rootElement = portletDataContext.getExportDataRootElement();
        Element portletsElement = rootElement.element("site-portlets");
        Element servicesElement = rootElement.element("site-services");
        String type = portletDataContext.getType();
        boolean permissions = MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"PERMISSIONS");
        Group group = stagedGroup.getGroup();
        List layouts = this._layoutLocalService.getLayouts(group.getGroupId(), portletDataContext.isPrivateLayout());
        for (String portletId : portletIds) {
            this._exportPortlet(portletDataContext, portletId, 0L, portletDataContext.getGroupId(), "", "", type, portletsElement, servicesElement, permissions);
            Portlet portlet = this._portletLocalService.getPortletById(portletDataContext.getCompanyId(), portletId);
            if (!portlet.isScopeable()) continue;
            for (Layout layout : layouts) {
                LayoutTypePortlet layoutTypePortlet;
                if (!ArrayUtil.contains((long[])layoutIds, (long)layout.getLayoutId()) || !layout.isTypePortlet() || !layout.hasScopeGroup() || !(layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType()).hasPortletId(portletId)) continue;
                Group scopeGroup = layout.getScopeGroup();
                this._exportPortlet(portletDataContext, portletId, layout.getPlid(), scopeGroup.getGroupId(), "", layout.getUuid(), type, portletsElement, servicesElement, permissions);
            }
        }
    }

    private void _importSitePortlets(PortletDataContext portletDataContext, List<Element> sitePortletElements) throws Exception {
        Map layouts = portletDataContext.getNewPrimaryKeysMap(Layout.class + ".layout");
        boolean permissions = MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"PERMISSIONS");
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        this._permissionImporter.clearCache();
        for (Element portletElement : sitePortletElements) {
            String portletId = portletElement.attributeValue("portlet-id");
            Portlet portlet = this._portletLocalService.getPortletById(portletDataContext.getCompanyId(), portletId);
            if (!portlet.isActive() || portlet.isUndeployedPortlet()) continue;
            long layoutId = GetterUtil.getLong((String)portletElement.attributeValue("layout-id"));
            Layout layout = (Layout)layouts.get(layoutId);
            long plid = 0L;
            if (layout != null) {
                if (this._sites.isLayoutModifiedSinceLastMerge(layout)) continue;
                plid = layout.getPlid();
            }
            portletDataContext.setPlid(plid);
            portletDataContext.setPortletId(portletId);
            if (BackgroundTaskThreadLocal.hasBackgroundTask()) {
                this._portletDataHandlerStatusMessageSender.sendStatusMessage("portlet", portletId, portletDataContext.getManifestSummary());
            }
            String portletPath = portletElement.attributeValue("path");
            Document portletDocument = SAXReaderUtil.read((String)portletDataContext.getZipEntryAsString(portletPath));
            portletElement = portletDocument.getRootElement();
            this._exportImportHelper.setPortletScope(portletDataContext, portletElement);
            long portletPreferencesGroupId = portletDataContext.getGroupId();
            Element portletDataElement = portletElement.element("portlet-data");
            Map importPortletControlsMap = this._exportImportHelper.getImportPortletControlsMap(portletDataContext.getCompanyId(), portletId, portletDataContext.getParameterMap(), portletDataElement, portletDataContext.getManifestSummary());
            if (layout != null) {
                portletPreferencesGroupId = layout.getGroupId();
            }
            try {
                this._exportImportLifecycleManager.fireExportImportLifecycleEvent(12, this.getProcessFlag(), portletDataContext.getExportImportProcessId(), new Serializable[]{this._portletDataContextFactory.clonePortletDataContext(portletDataContext)});
                this._portletImportController.importPortletPreferences(portletDataContext, portletDataContext.getCompanyId(), portletPreferencesGroupId, layout, portletElement, false, ((Boolean)importPortletControlsMap.get("PORTLET_ARCHIVED_SETUPS")).booleanValue(), ((Boolean)importPortletControlsMap.get("PORTLET_DATA")).booleanValue(), ((Boolean)importPortletControlsMap.get("PORTLET_SETUP")).booleanValue(), ((Boolean)importPortletControlsMap.get("PORTLET_USER_PREFERENCES")).booleanValue());
                if (((Boolean)importPortletControlsMap.get("PORTLET_DATA")).booleanValue()) {
                    this._portletImportController.importPortletData(portletDataContext, portletDataElement);
                }
                this._exportImportLifecycleManager.fireExportImportLifecycleEvent(11, this.getProcessFlag(), portletDataContext.getExportImportProcessId(), new Serializable[]{this._portletDataContextFactory.clonePortletDataContext(portletDataContext)});
            }
            catch (Throwable throwable) {
                this._exportImportLifecycleManager.fireExportImportLifecycleEvent(10, this.getProcessFlag(), portletDataContext.getExportImportProcessId(), new Serializable[]{this._portletDataContextFactory.clonePortletDataContext(portletDataContext), throwable});
                throw throwable;
            }
            finally {
                this._portletImportController.resetPortletScope(portletDataContext, portletPreferencesGroupId);
            }
            if (permissions) {
                this._permissionImporter.importPortletPermissions(portletDataContext.getCompanyId(), portletDataContext.getGroupId(), serviceContext.getUserId(), layout, portletElement, portletId);
            }
            this._portletImportController.importPortletPreferences(portletDataContext, portletDataContext.getCompanyId(), portletDataContext.getGroupId(), null, portletElement, false, ((Boolean)importPortletControlsMap.get("PORTLET_ARCHIVED_SETUPS")).booleanValue(), ((Boolean)importPortletControlsMap.get("PORTLET_DATA")).booleanValue(), ((Boolean)importPortletControlsMap.get("PORTLET_SETUP")).booleanValue(), ((Boolean)importPortletControlsMap.get("PORTLET_USER_PREFERENCES")).booleanValue());
        }
    }

    private void _importSiteServices(PortletDataContext portletDataContext, List<Element> siteServiceElements) throws Exception {
        for (Element serviceElement : siteServiceElements) {
            String path = serviceElement.attributeValue("path");
            Document siteServiceDocument = SAXReaderUtil.read((String)portletDataContext.getZipEntryAsString(path));
            serviceElement = siteServiceDocument.getRootElement();
            this._portletImportController.importServicePortletPreferences(portletDataContext, serviceElement);
        }
    }
}

