/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.internal.model.listener;

import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.Role;
import com.liferay.site.configuration.manager.MenuAccessConfigurationManager;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class RoleModelListener
extends BaseModelListener<Role> {
    private static final Log _log = LogFactoryUtil.getLog(RoleModelListener.class);
    @Reference
    private MenuAccessConfigurationManager _menuAccessConfigurationManager;

    public void onAfterCreate(Role role) throws ModelListenerException {
        if (role.getType() == 1 || role.getType() == 2) {
            try {
                this._menuAccessConfigurationManager.addAccessRoleToControlMenu(role);
            }
            catch (Exception exception) {
                _log.error((Throwable)exception);
            }
        }
    }

    public void onAfterRemove(Role role) throws ModelListenerException {
        if (role.getType() == 1 || role.getType() == 2) {
            try {
                this._menuAccessConfigurationManager.deleteRoleAccessToControlMenu(role);
            }
            catch (Exception exception) {
                _log.error((Throwable)exception);
            }
        }
    }
}

