/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.internal.provider.helper;

import com.liferay.layout.seo.model.LayoutSEOEntry;
import com.liferay.layout.seo.service.LayoutSEOEntryLocalService;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.site.provider.helper.SitemapURLProviderHelper;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={SitemapURLProviderHelper.class})
public class SitemapURLProviderHelperImpl
implements SitemapURLProviderHelper {
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutSEOEntryLocalService _layoutSEOEntryLocalService;

    public boolean isExcludeLayoutFromSitemap(Layout layout) {
        Layout parentLayout;
        if (layout == null) {
            return true;
        }
        UnicodeProperties typeSettingsUnicodeProperties = layout.getTypeSettingsProperties();
        if (!GetterUtil.getBoolean((String)typeSettingsUnicodeProperties.getProperty("sitemap-include"), (boolean)true) || !layout.isPublished()) {
            return true;
        }
        LayoutSEOEntry layoutSEOEntry = this._layoutSEOEntryLocalService.fetchLayoutSEOEntry(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId());
        if (layoutSEOEntry != null && layoutSEOEntry.isCanonicalURLEnabled()) {
            return true;
        }
        Map robotsMap = layout.getRobotsMap();
        for (Map.Entry entry : robotsMap.entrySet()) {
            String value = (String)entry.getValue();
            if (!StringUtil.containsIgnoreCase((String)value, (String)"nofollow", (String)"") && !StringUtil.containsIgnoreCase((String)value, (String)"noindex", (String)"")) continue;
            return true;
        }
        long parentPlid = layout.getParentPlid();
        while (parentPlid > 0L && (parentLayout = this._layoutLocalService.fetchLayout(parentPlid)) != null) {
            typeSettingsUnicodeProperties = parentLayout.getTypeSettingsProperties();
            if (!GetterUtil.getBoolean((String)typeSettingsUnicodeProperties.getProperty("sitemap-include-child-layouts"), (boolean)true)) {
                return true;
            }
            parentPlid = parentLayout.getParentPlid();
        }
        return false;
    }
}

