/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.internal.util;

import com.liferay.exportimport.kernel.configuration.ExportImportConfigurationSettingsMapFactoryUtil;
import com.liferay.exportimport.kernel.lar.ExportImportHelper;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.exportimport.kernel.service.ExportImportConfigurationLocalService;
import com.liferay.exportimport.kernel.service.ExportImportLocalService;
import com.liferay.exportimport.kernel.staging.MergeLayoutPrototypesThreadLocal;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.background.task.util.comparator.BackgroundTaskCreateDateComparator;
import com.liferay.portal.kernel.backgroundtask.BackgroundTask;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskManager;
import com.liferay.portal.kernel.change.tracking.CTTransactionException;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.lock.Lock;
import com.liferay.portal.kernel.lock.LockManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Image;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutPrototype;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutSetPrototype;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.VirtualLayout;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ImageLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutPrototypeLocalService;
import com.liferay.portal.kernel.service.LayoutSetLocalService;
import com.liferay.portal.kernel.service.LayoutSetPrototypeLocalService;
import com.liferay.portal.kernel.service.LayoutSetService;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.service.PortletPreferencesLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LinkedHashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.PortletPreferencesImpl;
import com.liferay.sites.kernel.util.Sites;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.PortletPreferences;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Sites.class})
public class SitesImpl
implements Sites {
    private static final String _TEMP_DIR = SystemProperties.get((String)"java.io.tmpdir") + "/liferay/layout_set_prototype/";
    private static final Log _log = LogFactoryUtil.getLog(SitesImpl.class);
    @Reference
    private BackgroundTaskManager _backgroundTaskManager;
    @Reference
    private ExportImportConfigurationLocalService _exportImportConfigurationLocalService;
    @Reference
    private ExportImportHelper _exportImportHelper;
    @Reference
    private ExportImportLocalService _exportImportLocalService;
    private final ConcurrentHashMap<String, File> _exportInProgressMap = new ConcurrentHashMap();
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private ImageLocalService _imageLocalService;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutPrototypeLocalService _layoutPrototypeLocalService;
    @Reference
    private LayoutSetLocalService _layoutSetLocalService;
    @Reference
    private LayoutSetPrototypeLocalService _layoutSetPrototypeLocalService;
    @Reference
    private LayoutSetService _layoutSetService;
    @Reference
    private Portal _portal;
    @Reference
    private PortletLocalService _portletLocalService;
    @Reference
    private PortletPreferencesLocalService _portletPreferencesLocalService;
    @Reference
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private UserLocalService _userLocalService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyLayoutPrototype(LayoutPrototype layoutPrototype, Layout targetLayout, boolean linkEnabled) throws Exception {
        Locale siteDefaultLocale = LocaleThreadLocal.getSiteDefaultLocale();
        LayoutTypePortlet targetLayoutType = (LayoutTypePortlet)targetLayout.getLayoutType();
        List targetLayoutPortletIds = targetLayoutType.getPortletIds();
        Layout layoutPrototypeLayout = layoutPrototype.getLayout();
        byte[] iconBytes = null;
        if (layoutPrototypeLayout.isIconImage()) {
            Image image = this._imageLocalService.getImage(layoutPrototypeLayout.getIconImageId());
            iconBytes = image.getTextObj();
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Serializable originalLayoutPrototypeLinkEnabled = serviceContext.getAttribute("layoutPrototypeLinkEnabled");
        Serializable originalLayoutPrototypeUuid = serviceContext.getAttribute("layoutPrototypeUuid");
        try {
            serviceContext.setAttribute("layoutPrototypeLinkEnabled", (Serializable)Boolean.valueOf(linkEnabled));
            serviceContext.setAttribute("layoutPrototypeUuid", (Serializable)((Object)layoutPrototype.getUuid()));
            Locale targetSiteDefaultLocale = this._portal.getSiteDefaultLocale(targetLayout.getGroupId());
            LocaleThreadLocal.setSiteDefaultLocale((Locale)targetSiteDefaultLocale);
            targetLayout = this._layoutLocalService.updateLayout(targetLayout.getGroupId(), targetLayout.isPrivateLayout(), targetLayout.getLayoutId(), targetLayout.getParentLayoutId(), targetLayout.getNameMap(), targetLayout.getTitleMap(), targetLayout.getDescriptionMap(), targetLayout.getKeywordsMap(), targetLayout.getRobotsMap(), layoutPrototypeLayout.getType(), targetLayout.isHidden(), targetLayout.getFriendlyURLMap(), layoutPrototypeLayout.isIconImage(), iconBytes, 0L, 0L, layoutPrototypeLayout.getMasterLayoutPlid(), serviceContext);
        }
        finally {
            if (originalLayoutPrototypeLinkEnabled == null) {
                serviceContext.removeAttribute("layoutPrototypeLinkEnabled");
            } else {
                serviceContext.setAttribute("layoutPrototypeLinkEnabled", originalLayoutPrototypeLinkEnabled);
            }
            if (originalLayoutPrototypeUuid == null) {
                serviceContext.removeAttribute("layoutPrototypeUuid");
            } else {
                serviceContext.setAttribute("layoutPrototypeUuid", originalLayoutPrototypeUuid);
            }
            LocaleThreadLocal.setSiteDefaultLocale((Locale)siteDefaultLocale);
        }
        targetLayout = this._layoutLocalService.updateLayout(targetLayout.getGroupId(), targetLayout.isPrivateLayout(), targetLayout.getLayoutId(), layoutPrototypeLayout.getTypeSettings());
        this.copyExpandoBridgeAttributes(layoutPrototypeLayout, targetLayout);
        this.copyPortletPermissions(targetLayout, layoutPrototypeLayout);
        this.copyPortletSetups(layoutPrototypeLayout, targetLayout);
        this._layoutLocalService.updateLookAndFeel(targetLayout.getGroupId(), targetLayout.isPrivateLayout(), targetLayout.getLayoutId(), layoutPrototypeLayout.getThemeId(), layoutPrototypeLayout.getColorSchemeId(), layoutPrototypeLayout.getCss());
        this.deleteUnreferencedPortlets(targetLayoutPortletIds, targetLayout, layoutPrototypeLayout);
        targetLayout = this._layoutLocalService.getLayout(targetLayout.getPlid());
        UnicodeProperties typeSettingsUnicodeProperties = targetLayout.getTypeSettingsProperties();
        Date modifiedDate = targetLayout.getModifiedDate();
        typeSettingsUnicodeProperties.setProperty("last-merge-time", String.valueOf(modifiedDate.getTime()));
        this._layoutLocalService.updateLayout(targetLayout.getGroupId(), targetLayout.isPrivateLayout(), targetLayout.getLayoutId(), targetLayout.getTypeSettings());
        UnicodeProperties prototypeTypeSettingsUnicodeProperties = layoutPrototypeLayout.getTypeSettingsProperties();
        if (prototypeTypeSettingsUnicodeProperties.containsKey((Object)"merge-fail-count")) {
            prototypeTypeSettingsUnicodeProperties.remove((Object)"merge-fail-count");
            this._layoutLocalService.updateLayout(layoutPrototypeLayout);
        }
    }

    public void copyPortletPermissions(Layout targetLayout, Layout sourceLayout) throws Exception {
        List roles = this._roleLocalService.getGroupRelatedRoles(targetLayout.getGroupId());
        Group targetGroup = targetLayout.getGroup();
        LayoutTypePortlet sourceLayoutTypePortlet = (LayoutTypePortlet)sourceLayout.getLayoutType();
        List sourcePortletIds = sourceLayoutTypePortlet.getPortletIds();
        for (String sourcePortletId : sourcePortletIds) {
            String resourceName = PortletIdCodec.decodePortletName((String)sourcePortletId);
            String sourceResourcePrimKey = PortletPermissionUtil.getPrimaryKey((long)sourceLayout.getPlid(), (String)sourcePortletId);
            String targetResourcePrimKey = PortletPermissionUtil.getPrimaryKey((long)targetLayout.getPlid(), (String)sourcePortletId);
            List actionIds = ResourceActionsUtil.getPortletResourceActions((String)resourceName);
            for (Role role : roles) {
                String roleName = role.getName();
                if (roleName.equals("Administrator") || !targetGroup.isLayoutSetPrototype() && targetLayout.isPrivateLayout() && roleName.equals("Guest")) continue;
                List actions = this._resourcePermissionLocalService.getAvailableResourcePermissionActionIds(targetLayout.getCompanyId(), resourceName, 4, sourceResourcePrimKey, role.getRoleId(), (Collection)actionIds);
                this._resourcePermissionLocalService.setResourcePermissions(targetLayout.getCompanyId(), resourceName, 4, targetResourcePrimKey, role.getRoleId(), actions.toArray(new String[0]));
            }
        }
    }

    public void copyPortletSetups(Layout sourceLayout, Layout targetLayout) throws Exception {
        LayoutTypePortlet sourceLayoutTypePortlet = (LayoutTypePortlet)sourceLayout.getLayoutType();
        List sourcePortletIds = ListUtil.toList((List)sourceLayoutTypePortlet.getAllPortlets(), (Accessor)Portlet.PORTLET_ID_ACCESSOR);
        for (String sourcePortletId : sourcePortletIds) {
            PortletPreferences sourcePortletPreferences = PortletPreferencesFactoryUtil.getPortletSetup((Layout)sourceLayout, (String)sourcePortletId, null);
            PortletPreferencesImpl sourcePortletPreferencesImpl = (PortletPreferencesImpl)sourcePortletPreferences;
            PortletPreferences targetPortletPreferences = PortletPreferencesFactoryUtil.getPortletSetup((Layout)targetLayout, (String)sourcePortletId, null);
            PortletPreferencesImpl targetPortletPreferencesImpl = (PortletPreferencesImpl)targetPortletPreferences;
            this._portletPreferencesLocalService.updatePreferences(targetPortletPreferencesImpl.getOwnerId(), targetPortletPreferencesImpl.getOwnerType(), targetPortletPreferencesImpl.getPlid(), sourcePortletId, sourcePortletPreferences);
            if (sourcePortletPreferencesImpl.getOwnerId() != 0L && sourcePortletPreferencesImpl.getOwnerType() != 3) {
                sourcePortletPreferences = PortletPreferencesFactoryUtil.getLayoutPortletSetup((Layout)sourceLayout, (String)sourcePortletId);
                targetPortletPreferences = PortletPreferencesFactoryUtil.getLayoutPortletSetup((Layout)targetLayout, (String)sourcePortletId);
                targetPortletPreferencesImpl = (PortletPreferencesImpl)targetPortletPreferences;
                this._portletPreferencesLocalService.updatePreferences(targetPortletPreferencesImpl.getOwnerId(), targetPortletPreferencesImpl.getOwnerType(), targetPortletPreferencesImpl.getPlid(), sourcePortletId, sourcePortletPreferences);
            }
            ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
            this._updateLayoutScopes(serviceContext.getUserId(), sourceLayout, targetLayout, sourcePortletPreferences, targetPortletPreferences, sourcePortletId, serviceContext.getLanguageId());
        }
    }

    public boolean isLayoutModifiedSinceLastMerge(Layout layout) {
        if (layout == null || Validator.isNull((String)layout.getSourcePrototypeLayoutUuid()) || layout.isLayoutPrototypeLinkActive() || layout instanceof VirtualLayout || !layout.isLayoutUpdateable()) {
            return false;
        }
        long lastMergeTime = GetterUtil.getLong((String)layout.getTypeSettingsProperty("last-merge-time"));
        if (lastMergeTime == 0L) {
            return false;
        }
        Date existingLayoutModifiedDate = layout.getModifiedDate();
        return existingLayoutModifiedDate != null && existingLayoutModifiedDate.getTime() > lastMergeTime;
    }

    public boolean isLayoutSetMergeable(Group group, LayoutSet layoutSet) throws PortalException {
        if (!layoutSet.isLayoutSetPrototypeLinkActive() || group.isLayoutPrototype() || group.isLayoutSetPrototype()) {
            return false;
        }
        UnicodeProperties settingsUnicodeProperties = layoutSet.getSettingsProperties();
        long lastMergeTime = GetterUtil.getLong((String)settingsUnicodeProperties.getProperty("last-merge-time"));
        long lastMergeVersion = GetterUtil.getLong((String)settingsUnicodeProperties.getProperty("last-merge-version"));
        LayoutSetPrototype layoutSetPrototype = this._layoutSetPrototypeLocalService.getLayoutSetPrototypeByUuidAndCompanyId(layoutSet.getLayoutSetPrototypeUuid(), layoutSet.getCompanyId());
        Date modifiedDate = layoutSetPrototype.getModifiedDate();
        if (!(lastMergeTime < modifiedDate.getTime() || lastMergeVersion != 0L && lastMergeVersion != layoutSetPrototype.getMvccVersion() || this.isAnyFailedLayoutModifiedSinceLastMerge(layoutSet))) {
            return false;
        }
        UnicodeProperties layoutSetPrototypeSettingsUnicodeProperties = layoutSetPrototype.getSettingsProperties();
        boolean readyForPropagation = GetterUtil.getBoolean((String)layoutSetPrototypeSettingsUnicodeProperties.getProperty("readyForPropagation"), (boolean)true);
        if (!readyForPropagation && lastMergeTime != 0L) {
            return false;
        }
        LayoutSet layoutSetPrototypeLayoutSet = layoutSetPrototype.getLayoutSet();
        UnicodeProperties layoutSetPrototypeLayoutSetSettingsUnicodeProperties = layoutSetPrototypeLayoutSet.getSettingsProperties();
        int mergeFailCount = GetterUtil.getInteger((String)layoutSetPrototypeLayoutSetSettingsUnicodeProperties.getProperty("merge-fail-count"));
        if (mergeFailCount > PropsValues.LAYOUT_SET_PROTOTYPE_MERGE_FAIL_THRESHOLD) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Merge not performed because the fail threshold was ", "reached for layoutSetPrototypeId ", layoutSetPrototype.getLayoutSetPrototypeId(), " and layoutId ", layoutSetPrototypeLayoutSet.getLayoutSetId(), ". Update the count in the database to try again."}));
            }
            return false;
        }
        return true;
    }

    public void mergeLayoutPrototypeLayout(Group group, Layout layout) throws Exception {
        Group layoutSetPrototypeGroup;
        Layout sourcePrototypeLayout;
        String sourcePrototypeLayoutUuid = layout.getSourcePrototypeLayoutUuid();
        if (Validator.isNull((String)sourcePrototypeLayoutUuid)) {
            this.doMergeLayoutPrototypeLayout(group, layout);
            return;
        }
        LayoutSet layoutSet = layout.getLayoutSet();
        long layoutSetPrototypeId = layoutSet.getLayoutSetPrototypeId();
        if (layoutSetPrototypeId > 0L && (sourcePrototypeLayout = this._layoutLocalService.fetchLayoutByUuidAndGroupId(sourcePrototypeLayoutUuid, (layoutSetPrototypeGroup = this._groupLocalService.getLayoutSetPrototypeGroup(layout.getCompanyId(), layoutSetPrototypeId)).getGroupId(), true)) != null) {
            this.doMergeLayoutPrototypeLayout(layoutSetPrototypeGroup, sourcePrototypeLayout);
        }
        this.doMergeLayoutPrototypeLayout(group, layout);
    }

    public void mergeLayoutSetPrototypeLayouts(Group group, LayoutSet layoutSet) throws Exception {
        if (MergeLayoutPrototypesThreadLocal.isSkipMerge()) {
            return;
        }
        MergeLayoutPrototypesThreadLocal.setSkipMerge((boolean)true);
        layoutSet = this._layoutSetLocalService.fetchLayoutSet(layoutSet.getLayoutSetId());
        if (!this.isLayoutSetMergeable(group, layoutSet)) {
            return;
        }
        LayoutSetPrototype layoutSetPrototype = this._layoutSetPrototypeLocalService.getLayoutSetPrototypeByUuidAndCompanyId(layoutSet.getLayoutSetPrototypeUuid(), layoutSet.getCompanyId());
        this.mergeLayoutSetPrototypeLayoutsInBackground(layoutSetPrototype, layoutSet);
    }

    public void removeMergeFailFriendlyURLLayouts(LayoutSet layoutSet) throws PortalException {
        UnicodeProperties settingsUnicodeProperties = layoutSet.getSettingsProperties();
        if (settingsUnicodeProperties.containsKey((Object)"merge-fail-friendly-url-layouts")) {
            settingsUnicodeProperties.remove((Object)"merge-fail-friendly-url-layouts");
            this._layoutSetLocalService.updateLayoutSet(layoutSet);
        }
    }

    public void updateLayoutSetPrototypesLinks(Group group, long publicLayoutSetPrototypeId, long privateLayoutSetPrototypeId, boolean publicLayoutSetPrototypeLinkEnabled, boolean privateLayoutSetPrototypeLinkEnabled) throws Exception {
        this.updateLayoutSetPrototypeLink(group.getGroupId(), true, privateLayoutSetPrototypeId, privateLayoutSetPrototypeLinkEnabled);
        this.updateLayoutSetPrototypeLink(group.getGroupId(), false, publicLayoutSetPrototypeId, publicLayoutSetPrototypeLinkEnabled);
    }

    protected void deleteUnreferencedPortlets(List<String> targetLayoutPortletIds, Layout targetLayout, Layout sourceLayout) throws Exception {
        LayoutTypePortlet sourceLayoutType = (LayoutTypePortlet)sourceLayout.getLayoutType();
        ArrayList<String> unreferencedPortletIds = new ArrayList<String>(targetLayoutPortletIds);
        unreferencedPortletIds.removeAll(sourceLayoutType.getPortletIds());
        this._portletLocalService.deletePortlets(targetLayout.getCompanyId(), unreferencedPortletIds.toArray(new String[0]), targetLayout.getPlid());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doMergeLayoutPrototypeLayout(Group group, Layout layout) throws Exception {
        LayoutPrototype layoutPrototype;
        Layout layoutPrototypeLayout;
        Date modifiedDate;
        if (!layout.isLayoutPrototypeLinkActive() || group.isLayoutPrototype() || group.hasStagingGroup()) {
            return;
        }
        long lastMergeTime = GetterUtil.getLong((String)layout.getTypeSettingsProperty("last-merge-time"));
        if (lastMergeTime == 0L) {
            try {
                MergeLayoutPrototypesThreadLocal.setInProgress((boolean)true);
                Layout targetLayout = this._layoutLocalService.getLayout(layout.getPlid());
                if (targetLayout != null) {
                    lastMergeTime = GetterUtil.getLong((String)targetLayout.getTypeSettingsProperty("last-merge-time"));
                }
            }
            finally {
                MergeLayoutPrototypesThreadLocal.setInProgress((boolean)false);
            }
        }
        if (lastMergeTime >= (modifiedDate = (layoutPrototypeLayout = (layoutPrototype = this._layoutPrototypeLocalService.getLayoutPrototypeByUuidAndCompanyId(layout.getLayoutPrototypeUuid(), layout.getCompanyId())).getLayout()).getModifiedDate()).getTime()) {
            return;
        }
        UnicodeProperties prototypeTypeSettingsUnicodeProperties = layoutPrototypeLayout.getTypeSettingsProperties();
        int mergeFailCount = GetterUtil.getInteger((String)prototypeTypeSettingsUnicodeProperties.getProperty("merge-fail-count"));
        if (mergeFailCount > PropsValues.LAYOUT_PROTOTYPE_MERGE_FAIL_THRESHOLD) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Merge not performed because the fail threshold was ", "reached for layoutPrototypeId ", layoutPrototype.getLayoutPrototypeId(), " and layoutId ", layoutPrototypeLayout.getLayoutId(), ". Update the count in the database to try again."}));
            }
            return;
        }
        String owner = this._acquireLock(Layout.class.getName(), layout.getPlid(), PropsValues.LAYOUT_PROTOTYPE_MERGE_LOCK_MAX_TIME);
        if (owner == null) {
            return;
        }
        EntityCacheUtil.clearLocalCache();
        layout = this._layoutLocalService.fetchLayout(layout.getPlid());
        try {
            MergeLayoutPrototypesThreadLocal.setInProgress((boolean)true);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Applying layout prototype ", layoutPrototype.getUuid(), " (mvccVersion ", layoutPrototype.getMvccVersion(), ") to layout ", layout.getPlid(), " (mvccVersion ", layout.getMvccVersion(), ")"}));
            }
            this.applyLayoutPrototype(layoutPrototype, layout, true);
        }
        catch (CTTransactionException ctTransactionException) {
            throw ctTransactionException;
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            prototypeTypeSettingsUnicodeProperties.setProperty("merge-fail-count", String.valueOf(++mergeFailCount));
            this._layoutLocalService.updateLayout(layoutPrototypeLayout);
        }
        finally {
            MergeLayoutPrototypesThreadLocal.setInProgress((boolean)false);
            this._releaseLock(Layout.class.getName(), layout.getPlid(), owner);
        }
    }

    protected File exportLayoutSetPrototype(User user, LayoutSetPrototype layoutSetPrototype, Map<String, String[]> parameterMap, String cacheFileName) {
        File cacheFile = null;
        if (cacheFileName != null && (cacheFile = new File(cacheFileName)).exists()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Using cached layout set prototype LAR file " + cacheFile.getAbsolutePath()));
            }
            return cacheFile;
        }
        long layoutSetPrototypeGroupId = 0L;
        try {
            layoutSetPrototypeGroupId = layoutSetPrototype.getGroupId();
        }
        catch (PortalException portalException) {
            _log.error((Object)("Unable to get groupId for layout set prototype " + layoutSetPrototype.getLayoutSetPrototypeId()), (Throwable)portalException);
            return null;
        }
        List layoutSetPrototypeLayouts = this._layoutLocalService.getLayouts(layoutSetPrototypeGroupId, true);
        Map exportLayoutSettingsMap = ExportImportConfigurationSettingsMapFactoryUtil.buildExportLayoutSettingsMap((User)user, (long)layoutSetPrototypeGroupId, (boolean)true, (long[])this._exportImportHelper.getLayoutIds(layoutSetPrototypeLayouts), parameterMap);
        ExportImportConfiguration exportImportConfiguration = null;
        try {
            exportImportConfiguration = this._exportImportConfigurationLocalService.addDraftExportImportConfiguration(user.getUserId(), 0, exportLayoutSettingsMap);
        }
        catch (PortalException portalException) {
            _log.error((Object)"Unable to add draft export-import configuration", (Throwable)portalException);
            return null;
        }
        File file = null;
        try {
            file = this._exportImportLocalService.exportLayoutsAsFile(exportImportConfiguration);
        }
        catch (PortalException portalException) {
            _log.error((Object)("Unable to export layout set prototype " + layoutSetPrototype.getLayoutSetPrototypeId()), (Throwable)portalException);
            return null;
        }
        if (cacheFile == null) {
            return file;
        }
        try {
            FileUtil.copyFile((File)file, (File)cacheFile);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((String[])new String[]{"Copied ", file.getAbsolutePath(), " to ", cacheFile.getAbsolutePath()}));
            }
        }
        catch (Exception exception) {
            _log.error((Object)StringBundler.concat((String[])new String[]{"Unable to copy file ", file.getAbsolutePath(), " to ", cacheFile.getAbsolutePath()}), (Throwable)exception);
        }
        return cacheFile;
    }

    protected Map<String, String[]> getLayoutSetPrototypesParameters(boolean importData) {
        LinkedHashMap parameterMap = LinkedHashMapBuilder.put((Object)"DELETE_MISSING_LAYOUTS", (Object)new String[]{Boolean.FALSE.toString()}).put((Object)"DELETE_PORTLET_DATA", (Object)new String[]{Boolean.FALSE.toString()}).put((Object)"IGNORE_LAST_PUBLISH_DATE", (Object)new String[]{Boolean.TRUE.toString()}).put((Object)"LAYOUT_SET_SETTINGS", (Object)new String[]{Boolean.TRUE.toString()}).put((Object)"LAYOUT_SET_PROTOTYPE_LINK_ENABLED", (Object)new String[]{Boolean.TRUE.toString()}).put((Object)"LAYOUT_SET_PROTOTYPE_SETTINGS", (Object)new String[]{Boolean.TRUE.toString()}).put((Object)"LAYOUTS_IMPORT_MODE", (Object)new String[]{"CREATED_FROM_PROTOTYPE"}).put((Object)"PERMISSIONS", (Object)new String[]{Boolean.TRUE.toString()}).put((Object)"PORTLET_CONFIGURATION", (Object)new String[]{Boolean.TRUE.toString()}).put((Object)"PORTLET_CONFIGURATION_ALL", (Object)new String[]{Boolean.TRUE.toString()}).put((Object)"PORTLET_SETUP_ALL", (Object)new String[]{Boolean.TRUE.toString()}).put((Object)"THEME_REFERENCE", (Object)new String[]{Boolean.TRUE.toString()}).put((Object)"UPDATE_LAST_PUBLISH_DATE", (Object)new String[]{Boolean.FALSE.toString()}).put((Object)"USER_ID_STRATEGY", (Object)new String[]{"CURRENT_USER_ID"}).build();
        if (importData) {
            parameterMap.put("DATA_STRATEGY", new String[]{"DATA_STRATEGY_MIRROR"});
            parameterMap.put("LOGO", new String[]{Boolean.TRUE.toString()});
            parameterMap.put("PORTLET_DATA", new String[]{Boolean.TRUE.toString()});
            parameterMap.put("PORTLET_DATA_ALL", new String[]{Boolean.TRUE.toString()});
        } else {
            parameterMap.put("DELETE_LAYOUTS", new String[]{Boolean.TRUE.toString()});
            parameterMap.put("DELETIONS", new String[]{Boolean.TRUE.toString()});
            if (PropsValues.LAYOUT_SET_PROTOTYPE_PROPAGATE_LOGO) {
                parameterMap.put("LOGO", new String[]{Boolean.TRUE.toString()});
            } else {
                parameterMap.put("LOGO", new String[]{Boolean.FALSE.toString()});
            }
            parameterMap.put("PORTLET_DATA", new String[]{Boolean.FALSE.toString()});
            parameterMap.put("PORTLET_DATA_ALL", new String[]{Boolean.FALSE.toString()});
        }
        return parameterMap;
    }

    protected void importLayoutSetPrototype(LayoutSetPrototype layoutSetPrototype, long groupId, boolean privateLayout, Map<String, String[]> parameterMap, boolean importData) throws PortalException {
        File file = null;
        User user = this._userLocalService.getGuestUser(layoutSetPrototype.getCompanyId());
        long lastMergeVersion = layoutSetPrototype.getMvccVersion();
        parameterMap.put("lastMergeVersion", new String[]{String.valueOf(lastMergeVersion)});
        parameterMap.put("layoutSetPrototypeId", new String[]{String.valueOf(layoutSetPrototype.getLayoutSetPrototypeId())});
        if (importData) {
            file = this.exportLayoutSetPrototype(user, layoutSetPrototype, parameterMap, null);
        } else {
            String cacheFileName = StringBundler.concat((Object[])new Object[]{_TEMP_DIR, layoutSetPrototype.getUuid(), ".v", lastMergeVersion, ".lar"});
            file = this._exportInProgressMap.computeIfAbsent(cacheFileName, fileName -> this.exportLayoutSetPrototype(user, layoutSetPrototype, parameterMap, (String)fileName));
            this._exportInProgressMap.remove(cacheFileName);
        }
        LayoutSet layoutSet = this._layoutSetLocalService.getLayoutSet(groupId, privateLayout);
        if (file == null || this.isSkipImport(groupId, layoutSet, false, lastMergeVersion) || this.isSkipImport(groupId, layoutSet, true, lastMergeVersion)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Skipping import of layout set prototype ", layoutSetPrototype.getUuid(), " (mvccVersion ", layoutSetPrototype.getMvccVersion(), ") to layout set ", layoutSet.getLayoutSetId(), " (mvccVersion ", layoutSet.getMvccVersion(), ")"}));
            }
            return;
        }
        this.removeMergeFailFriendlyURLLayouts(layoutSet);
        Map importLayoutSettingsMap = ExportImportConfigurationSettingsMapFactoryUtil.buildImportLayoutSettingsMap((long)user.getUserId(), (long)groupId, (boolean)privateLayout, null, parameterMap, (Locale)user.getLocale(), (TimeZone)user.getTimeZone());
        ExportImportConfiguration exportImportConfiguration = this._exportImportConfigurationLocalService.addExportImportConfiguration(user.getUserId(), groupId, "", "", 6, importLayoutSettingsMap, 2, new ServiceContext());
        this._exportImportLocalService.importLayoutSetPrototypeInBackground(user.getUserId(), exportImportConfiguration, file);
    }

    protected boolean isAnyFailedLayoutModifiedSinceLastMerge(LayoutSet layoutSet) {
        UnicodeProperties unicodeProperties = layoutSet.getSettingsProperties();
        String uuids = unicodeProperties.getProperty("merge-fail-friendly-url-layouts");
        if (Validator.isNotNull((String)uuids)) {
            for (String uuid : StringUtil.split((String)uuids)) {
                Layout layout = this._layoutLocalService.fetchLayoutByUuidAndGroupId(uuid, layoutSet.getGroupId(), layoutSet.isPrivateLayout());
                if (layout == null) {
                    return true;
                }
                Date modifiedDate = layout.getModifiedDate();
                long lastMergeTime = GetterUtil.getLong((String)unicodeProperties.getProperty("last-merge-time"));
                if (modifiedDate.getTime() <= lastMergeTime) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isLayoutSetPrototypeMergeBackgroundTaskExists(LayoutSetPrototype layoutSetPrototype, LayoutSet layoutSet) throws PortalException {
        List incompleteBackgroundTasks = this._backgroundTaskManager.getBackgroundTasks(layoutSet.getGroupId(), "com.liferay.exportimport.internal.background.task.LayoutSetPrototypeMergeBackgroundTaskExecutor", false, -1, -1, (OrderByComparator)BackgroundTaskCreateDateComparator.getInstance((boolean)false));
        for (BackgroundTask incompleteBackgroundTask : incompleteBackgroundTasks) {
            Map settingsMap;
            Map parameterMap;
            long layoutSetId;
            long exportImportConfigurationId = MapUtil.getLong((Map)incompleteBackgroundTask.getTaskContextMap(), (String)"exportImportConfigurationId");
            ExportImportConfiguration exportImportConfiguration = this._exportImportConfigurationLocalService.fetchExportImportConfiguration(exportImportConfigurationId);
            if (exportImportConfiguration == null || (layoutSetId = MapUtil.getLong((Map)(parameterMap = (Map)(settingsMap = exportImportConfiguration.getSettingsMap()).get("parameterMap")), (String)"layoutSetId")) != layoutSet.getLayoutSetId()) continue;
            if (incompleteBackgroundTask.getStatus() != 1) {
                return true;
            }
            long lastMergeVersion = MapUtil.getLong((Map)parameterMap, (String)"lastMergeVersion");
            if (lastMergeVersion != layoutSetPrototype.getMvccVersion()) continue;
            return true;
        }
        return false;
    }

    protected boolean isSkipImport(long groupId, LayoutSet layoutSet, boolean completed, long lastMergeVersion) {
        BackgroundTask previousBackgroundTask = this._backgroundTaskManager.fetchFirstBackgroundTask(groupId, "com.liferay.exportimport.internal.background.task.LayoutSetPrototypeImportBackgroundTaskExecutor", completed, (OrderByComparator)BackgroundTaskCreateDateComparator.getInstance((boolean)false));
        if (previousBackgroundTask == null) {
            return false;
        }
        Map contextMap = previousBackgroundTask.getTaskContextMap();
        ExportImportConfiguration previousExportImportConfiguration = this._exportImportConfigurationLocalService.fetchExportImportConfiguration(MapUtil.getLong((Map)contextMap, (String)"exportImportConfigurationId"));
        if (previousExportImportConfiguration == null) {
            return false;
        }
        Map settingsMap = previousExportImportConfiguration.getSettingsMap();
        Map parameterMap = (Map)settingsMap.get("parameterMap");
        long previousLastMergeVersion = MapUtil.getLong((Map)parameterMap, (String)"lastMergeVersion");
        if (previousLastMergeVersion == lastMergeVersion) {
            if (this.isAnyFailedLayoutModifiedSinceLastMerge(layoutSet)) {
                return false;
            }
            UnicodeProperties settingsUnicodeProperties = layoutSet.getSettingsProperties();
            long lastResetTime = GetterUtil.getLong((String)settingsUnicodeProperties.getProperty("last-reset-time"));
            Date previousBackgroundTaskCreateDate = previousBackgroundTask.getCreateDate();
            if (previousBackgroundTaskCreateDate.getTime() > lastResetTime) {
                return true;
            }
        }
        return false;
    }

    protected void mergeLayoutSetPrototypeLayoutsInBackground(LayoutSetPrototype layoutSetPrototype, LayoutSet layoutSet) throws PortalException {
        if (ExportImportThreadLocal.isExportInProcess() || ExportImportThreadLocal.isImportInProcess() || ExportImportThreadLocal.isStagingInProcess()) {
            return;
        }
        if (this.isLayoutSetPrototypeMergeBackgroundTaskExists(layoutSetPrototype, layoutSet)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Layout set prototype merge is in progress for layout set " + layoutSet.getLayoutSetId()));
            }
            return;
        }
        UnicodeProperties settingsUnicodeProperties = layoutSet.getSettingsProperties();
        boolean importData = true;
        long lastMergeTime = GetterUtil.getLong((String)settingsUnicodeProperties.getProperty("last-merge-time"));
        long lastResetTime = GetterUtil.getLong((String)settingsUnicodeProperties.getProperty("last-reset-time"));
        if (lastMergeTime > 0L || lastResetTime > 0L) {
            importData = false;
        }
        Map<String, String[]> parameterMap = this.getLayoutSetPrototypesParameters(importData);
        parameterMap.put("LAYOUT_SET_PRIVATE_LAYOUT", new String[]{String.valueOf(layoutSet.isPrivateLayout())});
        parameterMap.put("anyFailedLayoutModifiedSinceLastMerge", new String[]{String.valueOf(this.isAnyFailedLayoutModifiedSinceLastMerge(layoutSet))});
        parameterMap.put("importData", new String[]{String.valueOf(importData)});
        parameterMap.put("lastMergeVersion", new String[]{String.valueOf(layoutSetPrototype.getMvccVersion())});
        parameterMap.put("layoutSetId", new String[]{String.valueOf(layoutSet.getLayoutSetId())});
        parameterMap.put("layoutSetPrototypeId", new String[]{String.valueOf(layoutSetPrototype.getLayoutSetPrototypeId())});
        User user = this._userLocalService.getDefaultUser(layoutSet.getCompanyId());
        List layoutSetPrototypeLayouts = this._layoutLocalService.getLayouts(layoutSetPrototype.getGroupId(), true);
        Map exportLayoutSettingsMap = ExportImportConfigurationSettingsMapFactoryUtil.buildExportLayoutSettingsMap((User)user, (long)layoutSetPrototype.getGroupId(), (boolean)true, (long[])this._exportImportHelper.getLayoutIds(layoutSetPrototypeLayouts), parameterMap);
        ExportImportConfiguration exportImportConfiguration = null;
        try {
            exportImportConfiguration = this._exportImportConfigurationLocalService.addDraftExportImportConfiguration(user.getUserId(), 0, exportLayoutSettingsMap);
        }
        catch (PortalException portalException) {
            _log.error((Object)"Unable to add draft export-import configuration", (Throwable)portalException);
            return;
        }
        this._exportImportLocalService.mergeLayoutSetPrototypeInBackground(user.getUserId(), layoutSet.getGroupId(), exportImportConfiguration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateLayoutSetPrototypeLink(long groupId, boolean privateLayout, long layoutSetPrototypeId, boolean layoutSetPrototypeLinkEnabled) throws Exception {
        LayoutSetPrototype layoutSetPrototype;
        String layoutSetPrototypeUuid = null;
        if (layoutSetPrototypeId > 0L && (layoutSetPrototype = this._layoutSetPrototypeLocalService.fetchLayoutSetPrototype(layoutSetPrototypeId)) != null) {
            layoutSetPrototypeUuid = layoutSetPrototype.getUuid();
            if (!layoutSetPrototypeLinkEnabled && layoutSetPrototypeId > 0L) {
                boolean mergeLayoutPrototypesThreadLocalInProgress = MergeLayoutPrototypesThreadLocal.isInProgress();
                try {
                    MergeLayoutPrototypesThreadLocal.setInProgress((boolean)true);
                    this.importLayoutSetPrototype(layoutSetPrototype, groupId, privateLayout, this.getLayoutSetPrototypesParameters(true), true);
                }
                finally {
                    MergeLayoutPrototypesThreadLocal.setInProgress((boolean)mergeLayoutPrototypesThreadLocalInProgress);
                }
            }
        }
        this._layoutSetService.updateLayoutSetPrototypeLinkEnabled(groupId, privateLayout, layoutSetPrototypeLinkEnabled, layoutSetPrototypeUuid);
        this._layoutLocalService.updatePriorities(groupId, privateLayout);
    }

    private String _acquireLock(String className, long classPK, long mergeLockMaxTime) {
        String owner;
        block6: {
            owner = PortalUUIDUtil.generate();
            try {
                Lock lock = LockManagerUtil.lock((String)SitesImpl.class.getName(), (String)String.valueOf(classPK), (String)owner);
                if (owner.equals(lock.getOwner())) break block6;
                Date createDate = lock.getCreateDate();
                if (System.currentTimeMillis() - createDate.getTime() >= mergeLockMaxTime) {
                    lock = LockManagerUtil.lock((String)SitesImpl.class.getName(), (String)String.valueOf(classPK), (String)lock.getOwner(), (String)owner);
                    if (!owner.equals(lock.getOwner())) {
                        return null;
                    }
                    break block6;
                }
                return null;
            }
            catch (Exception exception) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)exception);
                }
                return null;
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Acquired lock for ", SitesImpl.class.getName(), " to update ", className, "#", classPK}));
        }
        return owner;
    }

    private void _releaseLock(String className, long classPK, String owner) {
        LockManagerUtil.unlock((String)SitesImpl.class.getName(), (String)String.valueOf(classPK), (String)owner);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Released lock for ", SitesImpl.class.getName(), " to update ", className, "#", classPK}));
        }
    }

    private void _updateLayoutScopes(long userId, Layout sourceLayout, Layout targetLayout, PortletPreferences sourcePortletPreferences, PortletPreferences targetPortletPreferences, String sourcePortletId, String languageId) throws Exception {
        String scopeType = GetterUtil.getString((String)sourcePortletPreferences.getValue("lfrScopeType", null));
        if (Validator.isNull((String)scopeType) || !scopeType.equals("layout")) {
            return;
        }
        Layout targetScopeLayout = this._layoutLocalService.getLayoutByUuidAndGroupId(targetLayout.getUuid(), targetLayout.getGroupId(), targetLayout.isPrivateLayout());
        if (!targetScopeLayout.hasScopeGroup()) {
            this._groupLocalService.addGroup(userId, 0L, Layout.class.getName(), targetLayout.getPlid(), 0L, targetLayout.getNameMap(), null, 0, true, 0, null, false, true, null);
        }
        String newPortletTitle = this._portal.getNewPortletTitle(this._portal.getPortletTitle(PortletIdCodec.decodePortletName((String)sourcePortletId), languageId), String.valueOf(sourceLayout.getLayoutId()), targetLayout.getName(languageId));
        targetPortletPreferences.setValue("groupId", String.valueOf(targetLayout.getGroupId()));
        targetPortletPreferences.setValue("lfrScopeType", "layout");
        targetPortletPreferences.setValue("lfrScopeLayoutUuid", targetLayout.getUuid());
        targetPortletPreferences.setValue("portletSetupTitle_" + languageId, newPortletTitle);
        targetPortletPreferences.setValue("portletSetupUseCustomTitle", Boolean.TRUE.toString());
        targetPortletPreferences.store();
    }
}

