/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.initializer.testray.dispatch.task.executor.internal.dispatch.executor.util;

import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.rest.dto.v1_0.ObjectEntry;
import com.liferay.object.rest.manager.v1_0.DefaultObjectEntryManager;
import com.liferay.object.rest.manager.v1_0.ObjectEntryManager;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ObjectEntryUtil {
    private static final Map<String, ObjectDefinition> _objectDefinitionsMap = new HashMap<String, ObjectDefinition>();

    public static ObjectEntry addObjectEntry(DefaultDTOConverterContext defaultDTOConverterContext, String objectDefinitionShortName, ObjectEntryManager objectEntryManager, Map<String, Object> properties) throws Exception {
        ObjectDefinition objectDefinition = ObjectEntryUtil._getObjectDefinition(objectDefinitionShortName);
        ObjectEntry objectEntry = new ObjectEntry();
        objectEntry.setProperties(properties);
        return objectEntryManager.addObjectEntry((DTOConverterContext)defaultDTOConverterContext, objectDefinition, objectEntry, null);
    }

    public static List<ObjectEntry> getObjectEntries(Aggregation aggregation, long companyId, DefaultDTOConverterContext defaultDTOConverterContext, String filterString, String objectDefinitionShortName, ObjectEntryManager objectEntryManager, Sort[] sorts) throws Exception {
        Page<ObjectEntry> page = ObjectEntryUtil.getObjectEntriesPage(aggregation, companyId, defaultDTOConverterContext, filterString, objectDefinitionShortName, objectEntryManager, sorts);
        return (List)page.getItems();
    }

    public static Page<ObjectEntry> getObjectEntriesPage(Aggregation aggregation, long companyId, DefaultDTOConverterContext defaultDTOConverterContext, String filterString, String objectDefinitionShortName, ObjectEntryManager objectEntryManager, Sort[] sorts) throws Exception {
        return objectEntryManager.getObjectEntries(companyId, ObjectEntryUtil._getObjectDefinition(objectDefinitionShortName), null, aggregation, (DTOConverterContext)defaultDTOConverterContext, filterString, null, null, sorts);
    }

    public static ObjectEntry getObjectEntry(DefaultDTOConverterContext defaultDTOConverterContext, String objectDefinitionShortName, long objectEntryId, ObjectEntryManager objectEntryManager) throws Exception {
        DefaultObjectEntryManager defaultObjectEntryManager = (DefaultObjectEntryManager)objectEntryManager;
        return defaultObjectEntryManager.getObjectEntry((DTOConverterContext)defaultDTOConverterContext, ObjectEntryUtil._getObjectDefinition(objectDefinitionShortName), objectEntryId);
    }

    public static Object getProperty(String key, ObjectEntry objectEntry) {
        Map properties = objectEntry.getProperties();
        return properties.get(key);
    }

    public static long increment(long companyId, DefaultDTOConverterContext defaultDTOConverterContext, String filterString, String key, String objectDefinitionShortName, ObjectEntryManager objectEntryManager, Sort[] sorts) throws Exception {
        Page<ObjectEntry> page = ObjectEntryUtil.getObjectEntriesPage(null, companyId, defaultDTOConverterContext, filterString, objectDefinitionShortName, objectEntryManager, sorts);
        ObjectEntry objectEntry = (ObjectEntry)page.fetchFirstItem();
        if (objectEntry == null) {
            return 1L;
        }
        Long fieldValue = (Long)ObjectEntryUtil.getProperty(key, objectEntry);
        if (fieldValue == null) {
            return 1L;
        }
        return fieldValue + 1L;
    }

    public static void loadObjectDefinitions(long companyId, ObjectDefinitionLocalService objectDefinitionLocalService) {
        List objectDefinitions = objectDefinitionLocalService.getObjectDefinitions(companyId, true, 0);
        if (ListUtil.isEmpty((List)objectDefinitions)) {
            return;
        }
        for (ObjectDefinition objectDefinition : objectDefinitions) {
            if (_objectDefinitionsMap.get(objectDefinition.getShortName()) != null) continue;
            _objectDefinitionsMap.put(objectDefinition.getShortName(), objectDefinition);
        }
    }

    public static void updateObjectEntry(DefaultDTOConverterContext defaultDTOConverterContext, String objectDefinitionShortName, ObjectEntry objectEntry, long objectEntryId, ObjectEntryManager objectEntryManager) throws Exception {
        DefaultObjectEntryManager defaultObjectEntryManager = (DefaultObjectEntryManager)objectEntryManager;
        defaultObjectEntryManager.updateObjectEntry((DTOConverterContext)defaultDTOConverterContext, ObjectEntryUtil._getObjectDefinition(objectDefinitionShortName), objectEntryId, objectEntry);
    }

    private static ObjectDefinition _getObjectDefinition(String objectDefinitionShortName) throws Exception {
        ObjectDefinition objectDefinition = _objectDefinitionsMap.get(objectDefinitionShortName);
        if (objectDefinition == null) {
            throw new PortalException("No object definition found with short name " + objectDefinitionShortName);
        }
        return objectDefinition;
    }
}

