<%--
/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */
--%>

<%@ include file="/init.jsp" %>

<%
ResultRow row = (ResultRow)request.getAttribute(WebKeys.SEARCH_CONTAINER_RESULT_ROW);

UserGroup userGroup = (UserGroup)row.getObject();
%>

<liferay-ui:icon-menu
	direction="left-side"
	icon="<%= StringPool.BLANK %>"
	markupView="lexicon"
	message="<%= StringPool.BLANK %>"
	showWhenSingleIcon="<%= true %>"
>
	<c:if test="<%= GroupPermissionUtil.contains(permissionChecker, siteMembershipsDisplayContext.getGroup(), ActionKeys.ASSIGN_USER_ROLES) %>">
		<portlet:renderURL var="assignURL" windowState="<%= LiferayWindowState.POP_UP.toString() %>">
			<portlet:param name="mvcPath" value="/user_groups_roles.jsp" />
			<portlet:param name="userGroupId" value="<%= String.valueOf(userGroup.getUserGroupId()) %>" />
			<portlet:param name="groupId" value="<%= String.valueOf(siteMembershipsDisplayContext.getGroupId()) %>" />
		</portlet:renderURL>

		<liferay-ui:icon
			cssClass="assign-roles"
			data='<%=
				HashMapBuilder.<String, Object>put(
					"href", assignURL.toString()
				).put(
					"usergroupid", userGroup.getUserGroupId()
				).build()
			%>'
			id='<%= row.getRowId() + "assignRoles" %>'
			message="assign-roles"
			url="javascript:void(0);"
		/>

		<portlet:renderURL var="unassignURL" windowState="<%= LiferayWindowState.POP_UP.toString() %>">
			<portlet:param name="mvcPath" value="/user_groups_roles.jsp" />
			<portlet:param name="userGroupId" value="<%= String.valueOf(userGroup.getUserGroupId()) %>" />
			<portlet:param name="groupId" value="<%= String.valueOf(siteMembershipsDisplayContext.getGroupId()) %>" />
			<portlet:param name="assignRoles" value="<%= Boolean.FALSE.toString() %>" />
		</portlet:renderURL>

		<liferay-ui:icon
			cssClass="unassign-roles"
			data='<%=
				HashMapBuilder.<String, Object>put(
					"href", unassignURL.toString()
				).put(
					"usergroupid", userGroup.getUserGroupId()
				).build()
			%>'
			id='<%= row.getRowId() + "unassignRoles" %>'
			message="unassign-roles"
			url="javascript:void(0);"
		/>
	</c:if>

	<c:if test="<%= GroupPermissionUtil.contains(permissionChecker, siteMembershipsDisplayContext.getGroup(), ActionKeys.ASSIGN_MEMBERS) %>">
		<portlet:actionURL name="deleteGroupUserGroups" var="deleteGroupUserGroupsURL">
			<portlet:param name="redirect" value="<%= currentURL %>" />
			<portlet:param name="groupId" value="<%= String.valueOf(siteMembershipsDisplayContext.getGroupId()) %>" />
			<portlet:param name="removeUserGroupId" value="<%= String.valueOf(userGroup.getUserGroupId()) %>" />
		</portlet:actionURL>

		<liferay-ui:icon-delete
			message="remove-membership"
			url="<%= deleteGroupUserGroupsURL %>"
		/>
	</c:if>
</liferay-ui:icon-menu>

<aui:script sandbox="<%= true %>">
	var assignRolesLink = document.getElementById(
		'<portlet:namespace /><%= row.getRowId() %>assignRoles'
	);

	if (assignRolesLink) {
		assignRolesLink.addEventListener('click', (event) => {
			event.preventDefault();

			var target = event.currentTarget;

			var addUserGroupGroupRoleFm =
				document.<portlet:namespace />addUserGroupGroupRoleFm;

			if (!addUserGroupGroupRoleFm) {
				return;
			}

			Liferay.Util.setFormValues(addUserGroupGroupRoleFm, {
				userGroupId: target.dataset.usergroupid,
			});

			Liferay.Util.openSelectionModal({
				buttonAddLabel: '<liferay-ui:message key="done" />',
				multiple: true,
				onSelect: function (selectedItems) {
					if (selectedItems.length) {
						const input = document.createElement('input');

						input.name = '<portlet:namespace />rowIds';

						const selectedUserGroupIds = Array.prototype.map.call(
							selectedItems,
							(item) => item.value
						);

						input.value = selectedUserGroupIds.join();

						addUserGroupGroupRoleFm.appendChild(input);

						submitForm(addUserGroupGroupRoleFm);
					}
				},
				title: '<liferay-ui:message key="assign-roles" />',
				url: target.dataset.href,
			});
		});
	}

	var unassignRolesLink = document.getElementById(
		'<portlet:namespace /><%= row.getRowId() %>unassignRoles'
	);

	if (unassignRolesLink) {
		unassignRolesLink.addEventListener('click', (event) => {
			event.preventDefault();

			var target = event.currentTarget;

			var unassignUserGroupGroupRoleFm =
				document.<portlet:namespace />unassignUserGroupGroupRoleFm;

			if (!unassignUserGroupGroupRoleFm) {
				return;
			}

			Liferay.Util.setFormValues(unassignUserGroupGroupRoleFm, {
				userGroupId: target.dataset.usergroupid,
			});

			Liferay.Util.openSelectionModal({
				buttonAddLabel: '<liferay-ui:message key="done" />',
				multiple: true,
				onSelect: function (selectedItems) {
					if (selectedItems.length) {
						const input = document.createElement('input');

						input.name = '<portlet:namespace />rowIds';

						const selectedUserGroupIds = Array.prototype.map.call(
							selectedItems,
							(item) => item.value
						);

						input.value = selectedUserGroupIds.join();

						unassignUserGroupGroupRoleFm.appendChild(input);

						submitForm(unassignUserGroupGroupRoleFm);
					}
				},
				selectEventName: '<portlet:namespace />selectUserGroupsRoles',
				title: '<liferay-ui:message key="unassign-roles" />',
				url: target.dataset.href,
			});
		});
	}
</aui:script>