Liferay.Loader.define("site-navigation-admin-web@3.0.35/site_navigation_menu_editor/components/MenuItem", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/card', '@frontend-taglib-clay$clayui/form', '@frontend-taglib-clay$clayui/icon', '@frontend-taglib-clay$clayui/layout', 'frontend-js-react-web$classnames', 'frontend-js-web', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../constants/nestingMargin', '../constants/sidebarPanelIds', '../contexts/ConstantsContext', '../contexts/ItemsContext', '../contexts/SelectedMenuItemIdContext', '../contexts/SidebarPanelIdContext', '../utils/deleteItem', '../utils/getItemPath', '../utils/useDragAndDrop'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.MenuItem = void 0;

    var _button = require("@frontend-taglib-clay$clayui/button");

    var _card = _interopRequireDefault(require("@frontend-taglib-clay$clayui/card"));

    var _form = require("@frontend-taglib-clay$clayui/form");

    var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

    var _layout = _interopRequireDefault(require("@frontend-taglib-clay$clayui/layout"));

    var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

    var _frontendJsWeb = require("frontend-js-web");

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

    var _nestingMargin = require("../constants/nestingMargin");

    var _sidebarPanelIds = require("../constants/sidebarPanelIds");

    var _ConstantsContext = require("../contexts/ConstantsContext");

    var _ItemsContext = require("../contexts/ItemsContext");

    var _SelectedMenuItemIdContext = require("../contexts/SelectedMenuItemIdContext");

    var _SidebarPanelIdContext = require("../contexts/SidebarPanelIdContext");

    var _deleteItem = _interopRequireDefault(require("../utils/deleteItem"));

    var _getItemPath = _interopRequireDefault(require("../utils/getItemPath"));

    var _useDragAndDrop = require("../utils/useDragAndDrop");

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    var MenuItem = function MenuItem(_ref) {
      var item = _ref.item;
      var setItems = (0, _ItemsContext.useSetItems)();
      var setSelectedMenuItemId = (0, _SelectedMenuItemIdContext.useSetSelectedMenuItemId)();
      var setSidebarPanelId = (0, _SidebarPanelIdContext.useSetSidebarPanelId)();

      var _useConstants = (0, _ConstantsContext.useConstants)(),
          deleteSiteNavigationMenuItemURL = _useConstants.deleteSiteNavigationMenuItemURL,
          editSiteNavigationMenuItemParentURL = _useConstants.editSiteNavigationMenuItemParentURL,
          languageDirection = _useConstants.languageDirection,
          languageId = _useConstants.languageId,
          portletNamespace = _useConstants.portletNamespace;

      var items = (0, _ItemsContext.useItems)();
      var siteNavigationMenuItemId = item.siteNavigationMenuItemId,
          title = item.title,
          type = item.type;
      var itemPath = (0, _getItemPath.default)(siteNavigationMenuItemId, items);
      var selected = (0, _SelectedMenuItemIdContext.useSelectedMenuItemId)() === siteNavigationMenuItemId;

      var _useDragItem = (0, _useDragAndDrop.useDragItem)(item, function updateMenuItemParent(itemId, parentId) {
        var _objectToFormData2;

        var order = items.filter(function (item) {
          return item.parentSiteNavigationMenuItemId === parentId;
        }).findIndex(function (item) {
          return item.siteNavigationMenuItemId === itemId;
        });
        (0, _frontendJsWeb.fetch)(editSiteNavigationMenuItemParentURL, {
          body: (0, _frontendJsWeb.objectToFormData)((_objectToFormData2 = {}, _defineProperty(_objectToFormData2, "".concat(portletNamespace, "siteNavigationMenuItemId"), itemId), _defineProperty(_objectToFormData2, "".concat(portletNamespace, "parentSiteNavigationMenuItemId"), parentId), _defineProperty(_objectToFormData2, "".concat(portletNamespace, "order"), order), _objectToFormData2)),
          method: 'POST'
        }).catch(function () {
          (0, _frontendJsWeb.openToast)({
            message: Liferay.Language.get('an-unexpected-error-occurred'),
            type: 'danger'
          });
        });
      }),
          handlerRef = _useDragItem.handlerRef,
          isDragging = _useDragItem.isDragging;

      var _useDropTarget = (0, _useDragAndDrop.useDropTarget)(item),
          targetRef = _useDropTarget.targetRef;

      var rtl = languageDirection[languageId] === 'rtl';
      var itemStyle = rtl ? {
        marginRight: (itemPath.length - 1) * _nestingMargin.NESTING_MARGIN
      } : {
        marginLeft: (itemPath.length - 1) * _nestingMargin.NESTING_MARGIN
      };
      var parentItemId = itemPath.length > 1 ? itemPath[itemPath.length - 2] : '0';
      return (/*#__PURE__*/_react.default.createElement("div", {
          "aria-label": "".concat(title, " (").concat(type, ")"),
          "aria-level": itemPath.length,
          "data-item-id": item.siteNavigationMenuItemId,
          "data-parent-item-id": parentItemId,
          ref: targetRef,
          role: "listitem"
        }, /*#__PURE__*/_react.default.createElement(_card.default, {
          className: (0, _classnames.default)('site_navigation_menu_editor_MenuItem', {
            dragging: isDragging,
            'site_navigation_menu_editor_MenuItem--selected': selected
          }),
          horizontal: true,
          selectable: true,
          style: itemStyle
        }, /*#__PURE__*/_react.default.createElement(_form.ClayCheckbox, {
          "aria-label": Liferay.Util.sub(Liferay.Language.get('select-x'), "".concat(title, " (").concat(type, ")")),
          checked: selected,
          onChange: function onChange() {
            setSelectedMenuItemId(siteNavigationMenuItemId);
            setSidebarPanelId(_sidebarPanelIds.SIDEBAR_PANEL_IDS.menuItemSettings);
          }
        }, /*#__PURE__*/_react.default.createElement(_card.default.Body, {
          className: "px-0"
        }, /*#__PURE__*/_react.default.createElement(_card.default.Row, null, /*#__PURE__*/_react.default.createElement(_layout.default.ContentCol, {
          gutters: true,
          ref: handlerRef
        }, /*#__PURE__*/_react.default.createElement(_icon.default, {
          symbol: "drag"
        })), /*#__PURE__*/_react.default.createElement(_layout.default.ContentCol, {
          expand: true
        }, /*#__PURE__*/_react.default.createElement(_card.default.Description, {
          displayType: "title"
        }, title), /*#__PURE__*/_react.default.createElement(_card.default.Description, {
          displayType: "subtitle"
        }, type)), /*#__PURE__*/_react.default.createElement(_layout.default.ContentCol, {
          gutters: true
        }, /*#__PURE__*/_react.default.createElement(_button.ClayButtonWithIcon, {
          "aria-label": Liferay.Util.sub(Liferay.Language.get('delete-x'), "".concat(title, " (").concat(type, ")")),
          displayType: "unstyled",
          onClick: function deleteMenuItem() {
            (0, _frontendJsWeb.fetch)(deleteSiteNavigationMenuItemURL, {
              body: (0, _frontendJsWeb.objectToFormData)(_defineProperty({}, "".concat(portletNamespace, "siteNavigationMenuItemId"), siteNavigationMenuItemId)),
              method: 'POST'
            }).then(function () {
              var newItems = (0, _deleteItem.default)(items, siteNavigationMenuItemId);
              setItems(newItems);
            }).catch(function () {
              (0, _frontendJsWeb.openToast)({
                message: Liferay.Language.get('an-unexpected-error-occurred'),
                type: 'danger'
              });
            });
          },
          small: true,
          symbol: "times-circle"
        })))))))
      );
    };

    exports.MenuItem = MenuItem;
    //# sourceMappingURL=MenuItem.js.map
  }
});
//# sourceMappingURL=MenuItem.js.map