Liferay.Loader.define("site-navigation-admin-web@3.0.35/site_navigation_menu_editor/utils/moveItem", ['module', 'exports', 'require', './getDescendantsCount', './updateItemParent'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = moveItem;

    var _getDescendantsCount = _interopRequireDefault(require("./getDescendantsCount"));

    var _updateItemParent = _interopRequireDefault(require("./updateItemParent"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _toConsumableArray(arr) {
      return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
    }

    function _nonIterableSpread() {
      throw new TypeError("Invalid attempt to spread non-iterable instance");
    }

    function _iterableToArray(iter) {
      if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
    }

    function _arrayWithoutHoles(arr) {
      if (Array.isArray(arr)) {
        for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
          arr2[i] = arr[i];
        }return arr2;
      }
    }

    function moveItem(items, itemId, parentId, newIndex, direction) {
      var itemIndex = items.findIndex(function (item) {
        return item.siteNavigationMenuItemId === itemId;
      });
      var newItems = (0, _updateItemParent.default)(items, itemId, parentId);
      var movedItems = newItems.filter(function (item, index) {
        return index >= itemIndex && index <= itemIndex + (0, _getDescendantsCount.default)(items, itemId);
      });
      return newItems.reduce(function (acc, item, index) {
        if (index === newIndex) {
          return direction === 'up' ? [].concat(_toConsumableArray(acc), _toConsumableArray(movedItems), [item]) : [].concat(_toConsumableArray(acc), [item], _toConsumableArray(movedItems));
        }

        if (movedItems.find(function (movedItem) {
          return movedItem.siteNavigationMenuItemId === item.siteNavigationMenuItemId;
        })) {
          return acc;
        } else {
          return [].concat(_toConsumableArray(acc), [item]);
        }
      }, []);
    }
    //# sourceMappingURL=moveItem.js.map
  }
});
//# sourceMappingURL=moveItem.js.map