Liferay.Loader.define("site-navigation-admin-web@3.0.35/site_navigation_menu_editor/utils/useDragAndDrop", ['module', 'exports', 'require', 'frontend-js-react-web$react', 'frontend-js-react-web$react-dnd', 'frontend-js-react-web$react-dnd-html5-backend', '../constants/acceptingItemType', '../constants/nestingMargin', '../contexts/ConstantsContext', '../contexts/ItemsContext', '../utils/updateItemParent', './getDescendantsCount', './getItemPath', './moveItem'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.useDragItem = useDragItem;
    exports.useDropTarget = useDropTarget;
    exports.DragDropProvider = void 0;

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _reactDnd = require("frontend-js-react-web$react-dnd");

    var _reactDndHtml5Backend = require("frontend-js-react-web$react-dnd-html5-backend");

    var _acceptingItemType = require("../constants/acceptingItemType");

    var _nestingMargin = require("../constants/nestingMargin");

    var _ConstantsContext = require("../contexts/ConstantsContext");

    var _ItemsContext = require("../contexts/ItemsContext");

    var _updateItemParent = _interopRequireDefault(require("../utils/updateItemParent"));

    var _getDescendantsCount = _interopRequireDefault(require("./getDescendantsCount"));

    var _getItemPath = _interopRequireDefault(require("./getItemPath"));

    var _moveItem = _interopRequireDefault(require("./moveItem"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    var DIRECTIONS = {
      down: 'down',
      inside: 'inside',
      outside: 'outside',
      up: 'up'
    };

    var DragDropContext = /*#__PURE__*/_react.default.createContext({});

    var DragDropProvider = function DragDropProvider(_ref) {
      var children = _ref.children;

      var _useState = (0, _react.useState)(null),
          _useState2 = _slicedToArray(_useState, 2),
          parentId = _useState2[0],
          setParentId = _useState2[1];

      var _useState3 = (0, _react.useState)(0),
          _useState4 = _slicedToArray(_useState3, 2),
          horizontalOffset = _useState4[0],
          setHorizontalOffset = _useState4[1];

      var _useState5 = (0, _react.useState)(0),
          _useState6 = _slicedToArray(_useState5, 2),
          verticalOffset = _useState6[0],
          setVerticalOffset = _useState6[1];

      return (/*#__PURE__*/_react.default.createElement(DragDropContext.Provider, {
          value: {
            horizontalOffset: horizontalOffset,
            parentId: parentId,
            setHorizontalOffset: setHorizontalOffset,
            setParentId: setParentId,
            setVerticalOffset: setVerticalOffset,
            verticalOffset: verticalOffset
          }
        }, children)
      );
    };

    exports.DragDropProvider = DragDropProvider;

    function useDragItem(item, onDragEnd) {
      var parentSiteNavigationMenuItemId = item.parentSiteNavigationMenuItemId,
          siteNavigationMenuItemId = item.siteNavigationMenuItemId;
      var items = (0, _ItemsContext.useItems)();
      var itemPath = (0, _getItemPath.default)(siteNavigationMenuItemId, items);

      var _useContext = (0, _react.useContext)(DragDropContext),
          parentId = _useContext.parentId,
          setHorizontalOffset = _useContext.setHorizontalOffset,
          setParentId = _useContext.setParentId,
          setVerticalOffset = _useContext.setVerticalOffset;

      var _useDrag = (0, _reactDnd.useDrag)({
        begin: function begin() {
          setParentId(parentSiteNavigationMenuItemId);
        },
        collect: function collect(monitor) {
          return {
            isDragging: !!monitor.isDragging()
          };
        },
        end: function end() {
          onDragEnd(item.siteNavigationMenuItemId, parentId);
          setHorizontalOffset(0);
          setParentId(null);
          setVerticalOffset(null);
        },
        isDragging: function isDragging(monitor) {
          return itemPath.includes(monitor.getItem().id);
        },
        item: {
          id: siteNavigationMenuItemId,
          type: _acceptingItemType.ACCEPTING_ITEM_TYPE
        }
      }),
          _useDrag2 = _slicedToArray(_useDrag, 3),
          isDragging = _useDrag2[0].isDragging,
          handlerRef = _useDrag2[1],
          previewRef = _useDrag2[2];

      (0, _react.useEffect)(function () {
        previewRef((0, _reactDndHtml5Backend.getEmptyImage)(), {
          captureDraggingState: true
        });
      }, [previewRef]);
      return {
        handlerRef: handlerRef,
        isDragging: isDragging
      };
    }

    function useDropTarget(item) {
      var siteNavigationMenuItemId = item.siteNavigationMenuItemId;
      var items = (0, _ItemsContext.useItems)();
      var itemPath = (0, _getItemPath.default)(siteNavigationMenuItemId, items);
      var setItems = (0, _ItemsContext.useSetItems)();

      var _useConstants = (0, _ConstantsContext.useConstants)(),
          languageDirection = _useConstants.languageDirection,
          languageId = _useConstants.languageId;

      var rtl = languageDirection[languageId] === 'rtl';

      var _useContext2 = (0, _react.useContext)(DragDropContext),
          horizontalOffset = _useContext2.horizontalOffset,
          setHorizontalOffset = _useContext2.setHorizontalOffset,
          setParentId = _useContext2.setParentId,
          setVerticalOffset = _useContext2.setVerticalOffset,
          verticalOffset = _useContext2.verticalOffset;

      var _useDrop = (0, _reactDnd.useDrop)({
        accept: _acceptingItemType.ACCEPTING_ITEM_TYPE,
        canDrop: function canDrop(source, monitor) {
          return monitor.isOver();
        },
        hover: function hover(source, monitor) {
          if (monitor.canDrop(source, monitor)) {
            if (itemPath.includes(source.id)) {
              var data = computeHoverItself({
                initialOffset: horizontalOffset,
                items: items,
                monitor: monitor,
                rtl: rtl,
                source: source
              });

              if (data) {
                var currentOffset = data.currentOffset,
                    newParentId = data.newParentId;
                setParentId(newParentId);
                setHorizontalOffset(currentOffset);
                var newItems = (0, _updateItemParent.default)(items, source.id, newParentId);
                setItems(newItems);
              }
            } else {
              var _computeHoverAnotherI = computeHoverAnotherItem({
                initialOffset: verticalOffset,
                items: items,
                monitor: monitor,
                source: source,
                targetId: siteNavigationMenuItemId
              }),
                  _currentOffset = _computeHoverAnotherI.currentOffset,
                  direction = _computeHoverAnotherI.direction,
                  newIndex = _computeHoverAnotherI.newIndex,
                  _newParentId = _computeHoverAnotherI.newParentId;

              if (_newParentId) {
                setParentId(_newParentId);
                setHorizontalOffset(0);
                setVerticalOffset(_currentOffset);

                var _newItems = (0, _moveItem.default)(items, source.id, _newParentId, newIndex, direction);

                setItems(_newItems);
              }
            }
          }
        }
      }),
          _useDrop2 = _slicedToArray(_useDrop, 2),
          targetRef = _useDrop2[1];

      return {
        targetRef: targetRef
      };
    }

    function getHorizontalMovementDirection(initialOffset, currentOffset, rtl) {
      if (rtl) {
        return initialOffset < currentOffset ? DIRECTIONS.outside : DIRECTIONS.inside;
      } else {
        return initialOffset > currentOffset ? DIRECTIONS.outside : DIRECTIONS.inside;
      }
    }

    function computeHoverItself(_ref2) {
      var initialOffset = _ref2.initialOffset,
          items = _ref2.items,
          monitor = _ref2.monitor,
          rtl = _ref2.rtl,
          source = _ref2.source;
      var currentOffset = monitor.getDifferenceFromInitialOffset().x;

      if (Math.abs(initialOffset - currentOffset) < _nestingMargin.NESTING_MARGIN) {
        return;
      }

      var direction = getHorizontalMovementDirection(initialOffset, currentOffset, rtl);
      var sourceItem = items.find(function (item) {
        return item.siteNavigationMenuItemId === source.id;
      });
      var sourceItemIndex = items.indexOf(sourceItem);
      var newParentId;

      if (direction === DIRECTIONS.inside) {
        var previousSibling = items.filter(function (item, index) {
          return item.parentSiteNavigationMenuItemId === sourceItem.parentSiteNavigationMenuItemId && item.siteNavigationMenuItemId !== source.id && index < sourceItemIndex;
        }).pop();
        newParentId = previousSibling === null || previousSibling === void 0 ? void 0 : previousSibling.siteNavigationMenuItemId;
      } else {
        var nextSiblings = items.filter(function (item, index) {
          return item.parentSiteNavigationMenuItemId === sourceItem.parentSiteNavigationMenuItemId && item.siteNavigationMenuItemId !== source.id && index > sourceItemIndex;
        });

        if (!nextSiblings.length) {
          var parent = items.find(function (item) {
            return item.siteNavigationMenuItemId === sourceItem.parentSiteNavigationMenuItemId;
          });
          newParentId = parent === null || parent === void 0 ? void 0 : parent.parentSiteNavigationMenuItemId;
        }
      }

      if (!newParentId || newParentId === sourceItem.siteNavigationMenuItemId) {
        return;
      }

      return {
        currentOffset: currentOffset,
        newParentId: newParentId
      };
    }

    function computeHoverAnotherItem(_ref3) {
      var initialOffset = _ref3.initialOffset,
          items = _ref3.items,
          monitor = _ref3.monitor,
          source = _ref3.source,
          targetId = _ref3.targetId;
      var sourceItem = items.find(function (item) {
        return item.siteNavigationMenuItemId === source.id;
      });
      var targetItem = items.find(function (item) {
        return item.siteNavigationMenuItemId === targetId;
      });
      var currentOffset = monitor.getDifferenceFromInitialOffset().y;

      if (initialOffset === currentOffset) {
        return;
      }

      var direction = initialOffset > currentOffset ? DIRECTIONS.up : DIRECTIONS.down;
      var newIndex = items.indexOf(targetItem);

      if (newIndex === items.indexOf(sourceItem)) {
        return;
      }

      var newParentId;

      if (direction === DIRECTIONS.up) {
        newParentId = targetItem.parentSiteNavigationMenuItemId;
      }

      if (direction === DIRECTIONS.down) {
        var targetItemDescendantsCount = (0, _getDescendantsCount.default)(items, targetId);
        newParentId = targetItemDescendantsCount ? targetItem.siteNavigationMenuItemId : targetItem.parentSiteNavigationMenuItemId;
      }

      return {
        currentOffset: currentOffset,
        direction: direction,
        newIndex: newIndex,
        newParentId: newParentId
      };
    }
    //# sourceMappingURL=useDragAndDrop.js.map
  }
});
//# sourceMappingURL=useDragAndDrop.js.map