/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.navigation.menu.item.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PropertiesParamUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.UnicodePropertiesBuilder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.site.navigation.model.SiteNavigationMenuItem;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.portlet.PortletRequest;

public class SiteNavigationMenuItemUtil {
    public static UnicodeProperties getSiteNavigationMenuItemProperties(PortletRequest portletRequest, String prefix) throws PortalException {
        Map parameterMap = portletRequest.getParameterMap();
        Object[] localizableParameters = new String[]{};
        for (Object[] key : parameterMap.keySet()) {
            if (key.startsWith(prefix)) continue;
            localizableParameters = (String[])ArrayUtil.append((Object[])localizableParameters, (Object)key);
        }
        UnicodeProperties unicodeProperties = PropertiesParamUtil.getProperties((PortletRequest)portletRequest, (String)prefix);
        for (Object localizableParameter : localizableParameters) {
            Map map = LocalizationUtil.getLocalizationMap((PortletRequest)portletRequest, (String)localizableParameter);
            if (MapUtil.isEmpty((Map)map)) continue;
            for (Map.Entry entry : map.entrySet()) {
                String value = (String)entry.getValue();
                if (Validator.isNull((String)value)) continue;
                String key = (String)localizableParameter + "_" + LocaleUtil.toLanguageId((Locale)((Locale)entry.getKey()));
                unicodeProperties.setProperty(key, value);
            }
        }
        if (!unicodeProperties.containsKey((Object)"defaultLanguageId")) {
            ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            unicodeProperties.setProperty("defaultLanguageId", LocaleUtil.toLanguageId((Locale)PortalUtil.getSiteDefaultLocale((Group)themeDisplay.getScopeGroup())));
        }
        return unicodeProperties;
    }

    public static String getSiteNavigationMenuItemXML(SiteNavigationMenuItem siteNavigationMenuItem, String name) throws PortalException {
        if (siteNavigationMenuItem == null) {
            return "";
        }
        UnicodeProperties typeSettingsUnicodeProperties = UnicodePropertiesBuilder.fastLoad((String)siteNavigationMenuItem.getTypeSettings()).build();
        Set availableLocales = LanguageUtil.getAvailableLocales((long)siteNavigationMenuItem.getGroupId());
        if (Objects.equals(siteNavigationMenuItem.getType(), "layout")) {
            String layoutUuid = (String)typeSettingsUnicodeProperties.get((Object)"layoutUuid");
            boolean privateLayout = GetterUtil.getBoolean((String)((String)typeSettingsUnicodeProperties.get((Object)"privateLayout")));
            Layout layout = LayoutLocalServiceUtil.getLayoutByUuidAndGroupId((String)layoutUuid, (long)siteNavigationMenuItem.getGroupId(), (boolean)privateLayout);
            Map nameMap = layout.getNameMap();
            for (Map.Entry nameEntry : nameMap.entrySet()) {
                String languageId = LocaleUtil.toLanguageId((Locale)((Locale)nameEntry.getKey()));
                if (!Validator.isNull((String)typeSettingsUnicodeProperties.getProperty("name_" + languageId))) continue;
                typeSettingsUnicodeProperties.setProperty("name_" + languageId, (String)nameEntry.getValue());
            }
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (Locale locale : availableLocales) {
            String languageId = LocaleUtil.toLanguageId((Locale)locale);
            String value = typeSettingsUnicodeProperties.getProperty(name + "_" + languageId);
            if (!Validator.isNotNull((String)value)) continue;
            map.put(languageId, value);
        }
        if (MapUtil.isEmpty(map)) {
            String defaultLanguageId = typeSettingsUnicodeProperties.getProperty("defaultLanguageId", LocaleUtil.toLanguageId((Locale)PortalUtil.getSiteDefaultLocale((long)siteNavigationMenuItem.getGroupId())));
            map.put(defaultLanguageId, GetterUtil.getString((String)typeSettingsUnicodeProperties.getProperty(name)));
        }
        return LocalizationUtil.getXml(map, (String)LocaleUtil.toLanguageId((Locale)LocaleUtil.getMostRelevantLocale()), (String)name);
    }
}

