/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.core.prose;

import com.liferay.poshi.core.prose.BasePoshiProse;
import com.liferay.poshi.core.prose.PoshiProseScenario;
import com.liferay.poshi.core.util.Dom4JUtil;
import com.liferay.poshi.core.util.FileUtil;
import com.liferay.poshi.core.util.StringUtil;
import com.liferay.poshi.core.util.Validator;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Element;
import org.dom4j.tree.DefaultAttribute;

public class PoshiProseDefinition
extends BasePoshiProse {
    private static final Pattern _definitionPattern = Pattern.compile("(?s)(?<tags>\\@.*?)?(?<feature>Feature:.*?)?(?<scenarios>(Setup|Teardown|Scenario).*)");
    private final String _fileName;
    private final List<PoshiProseScenario> _poshiProseScenarios = new ArrayList<PoshiProseScenario>();
    private final Map<String, String> _tagMap = new LinkedHashMap<String, String>();

    public PoshiProseDefinition(URL url) throws IOException {
        this._fileName = url.getFile();
        String fileContent = null;
        try {
            fileContent = this.filterCommentLines(FileUtil.read(url));
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to read file: " + url.getFile(), ioException.getCause());
        }
        Matcher matcher = _definitionPattern.matcher(fileContent);
        if (matcher.find()) {
            String tags = matcher.group("tags");
            if (Validator.isNotNull(tags)) {
                Matcher tagMatcher = this.tagPattern.matcher(tags);
                while (tagMatcher.find()) {
                    this._tagMap.put(tagMatcher.group("tagName"), tagMatcher.group("tagValue"));
                }
            }
            String scenarios = matcher.group("scenarios");
            List<String> poshiProseScenarioStrings = StringUtil.split(scenarios, PoshiProseScenario.KEYWORDS);
            for (String poshiProseScenarioString : poshiProseScenarioStrings) {
                this._poshiProseScenarios.add(new PoshiProseScenario(poshiProseScenarioString));
            }
        }
    }

    public String getFileName() {
        return this._fileName;
    }

    @Override
    public Element toElement() {
        Element definitionElement = Dom4JUtil.getNewElement("definition");
        for (Map.Entry<String, String> entry : this._tagMap.entrySet()) {
            definitionElement.add(Dom4JUtil.getNewElement("property", null, new DefaultAttribute("name", entry.getKey()), new DefaultAttribute("value", entry.getValue())));
        }
        for (PoshiProseScenario poshiProseScenario : this._poshiProseScenarios) {
            definitionElement.add(poshiProseScenario.toElement());
        }
        return definitionElement;
    }
}

