/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import java.io.IOException;

public class BNDMultipleAppBNDsCheck
extends BaseFileCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        if (!absolutePath.endsWith("/app.bnd")) {
            return content;
        }
        this._checkMuldipleAppBND(fileName, absolutePath, "dxp");
        this._checkMuldipleAppBND(fileName, absolutePath, "private");
        return content;
    }

    private void _checkMuldipleAppBND(String fileName, String absolutePath, String dirName) throws IOException {
        int x = absolutePath.indexOf("/modules/" + dirName + "/apps/");
        if (x == -1) {
            return;
        }
        String portalAppBNDFileName = StringUtil.replaceFirst(absolutePath.substring(x + 1), "/" + dirName + "/", "/");
        if (this.getPortalContent(portalAppBNDFileName, absolutePath, true) != null) {
            this.addMessage(fileName, "Redundant app.bnd. There is one already: '" + portalAppBNDFileName + "'.");
        }
    }
}

