/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.util.FileUtil;
import com.liferay.source.formatter.util.SourceFormatterUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GradleRequiredDependenciesCheck
extends BaseFileCheck {
    private static final Pattern _dependencyNamePattern = Pattern.compile("compileOnly group: (\".* name: \"(.*?)\".*)");

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        if (!absolutePath.endsWith("/required-dependencies/required-dependencies/build.gradle")) {
            return content;
        }
        List<String> buildGradleContents = this._getBuildGradleContents();
        Matcher matcher = _dependencyNamePattern.matcher(content);
        while (matcher.find()) {
            this._checkDependency(fileName, content, matcher.group(1), matcher.group(2), buildGradleContents);
        }
        return content;
    }

    private void _checkDependency(String fileName, String content, String dependency, String dependencyName, List<String> buildGradleContents) {
        int count = 0;
        for (String buildGradleContent : buildGradleContents) {
            if (!buildGradleContent.contains(dependency) || ++count <= 1) continue;
            return;
        }
        int lineNumber = this.getLineNumber(content, content.indexOf(dependency));
        if (count == 0) {
            this.addMessage(fileName, StringBundler.concat("Remove dependency '", dependencyName, "' since it is not used by any module"), lineNumber);
        } else {
            this.addMessage(fileName, StringBundler.concat("Remove dependency '", dependencyName, "' since it is only used by 1 module"), lineNumber);
        }
    }

    private List<String> _getBuildGradleContents() throws IOException {
        ArrayList<String> buildGradleContents = new ArrayList<String>();
        String moduleAppsDirLocation = "modules/apps/";
        for (int i = 0; i < this.getMaxDirLevel() - 1; ++i) {
            File file = new File(this.getBaseDirName() + moduleAppsDirLocation);
            if (!file.exists()) {
                moduleAppsDirLocation = "../" + moduleAppsDirLocation;
                continue;
            }
            List<String> buildGradleFileNames = SourceFormatterUtil.scanForFiles(this.getBaseDirName() + moduleAppsDirLocation, new String[]{"**/required-dependencies/required-dependencies/build.gradle"}, new String[]{"**/build.gradle"}, this.getSourceFormatterExcludes(), false);
            for (String buildGradleFileName : buildGradleFileNames) {
                buildGradleContents.add(FileUtil.read(new File(buildGradleFileName)));
            }
            break;
        }
        return buildGradleContents;
    }
}

