/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.check.BaseJavaTermCheck;
import com.liferay.source.formatter.check.util.SourceUtil;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaTerm;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaAnnotationsCheck
extends BaseJavaTermCheck {
    private static final Pattern _annotationLineBreakPattern1 = Pattern.compile("[{=]\n.*(\" \\+\n\t*\")");
    private static final Pattern _arrayPattern = Pattern.compile("=\\s+\\{");
    private static final Pattern _pipePattern = Pattern.compile("(= \".*)( \\| | \\||\\| )");

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) throws Exception {
        return this.formatAnnotations(fileName, absolutePath, (JavaClass)javaTerm, fileContent);
    }

    protected String formatAnnotation(String fileName, String absolutePath, JavaClass javaClass, String fileContent, String annotation, String indent) throws Exception {
        if (!annotation.contains("(")) {
            return annotation;
        }
        annotation = this._fixAnnotationLineBreaks(annotation);
        annotation = this._fixSingleValueArray(annotation);
        annotation = this._fixWhitespaceAroundPipe(annotation);
        return annotation;
    }

    protected String formatAnnotations(String fileName, String absolutePath, JavaClass javaClass, String fileContent) throws Exception {
        String content = javaClass.getContent();
        if (javaClass.getParentJavaClass() != null) {
            return content;
        }
        List<String> annotationsBlocks = SourceUtil.getAnnotationsBlocks(content);
        for (String annotationsBlock : annotationsBlocks) {
            String indent = SourceUtil.getIndent(annotationsBlock);
            String newAnnotationsBlock = this._formatAnnotations(fileName, absolutePath, javaClass, fileContent, annotationsBlock, indent);
            content = StringUtil.replace(content, "\n" + annotationsBlock, "\n" + newAnnotationsBlock);
        }
        return content;
    }

    protected String getAnnotationAttributeValue(String annotation, String attributeName) {
        int start;
        Pattern pattern = Pattern.compile("[^\\w\"]" + attributeName + "\\s*=");
        Matcher matcher = pattern.matcher(annotation);
        if (!matcher.find()) {
            return null;
        }
        int end = start = matcher.end() + 1;
        do {
            if ((end = annotation.indexOf(44, end + 1)) != -1) continue;
            end = annotation.lastIndexOf(41);
            break;
        } while (ToolsUtil.isInsideQuotes(annotation, end) || this.getLevel(annotation.substring(start, end), "{", "}") != 0);
        String attributeValue = StringUtil.trim(annotation.substring(start, end));
        if (!attributeValue.contains("\n")) {
            return attributeValue;
        }
        return StringUtil.replace(attributeValue, new String[]{"\t", ",\n", "\n"}, new String[]{"", ", ", ""});
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_CLASS};
    }

    private String _fixAnnotationLineBreaks(String annotation) {
        Matcher matcher = _annotationLineBreakPattern1.matcher(annotation);
        if (matcher.find()) {
            return StringUtil.replaceFirst(annotation, matcher.group(1), "", matcher.start());
        }
        return annotation;
    }

    private String _fixSingleValueArray(String annotation) {
        Matcher matcher = _arrayPattern.matcher(annotation);
        block0: while (matcher.find()) {
            int x = matcher.start();
            if (ToolsUtil.isInsideQuotes(annotation, x)) continue;
            String arrayString = null;
            int y = x;
            do {
                if ((y = annotation.indexOf("}", y + 1)) != -1) continue;
                return annotation;
            } while (ToolsUtil.isInsideQuotes(annotation, y) || this.getLevel(arrayString = annotation.substring(matcher.end() - 1, y + 1), "{", "}") != 0);
            y = -1;
            while ((y = arrayString.indexOf(",", y + 1)) != -1) {
                if (ToolsUtil.isInsideQuotes(arrayString, y)) continue;
                continue block0;
            }
            String replacement = StringUtil.trim(arrayString.substring(1, arrayString.length() - 1));
            if (!Validator.isNotNull(replacement)) continue;
            return StringUtil.replace(annotation, arrayString, replacement);
        }
        return annotation;
    }

    private String _fixWhitespaceAroundPipe(String annotation) {
        Matcher matcher = _pipePattern.matcher(annotation);
        return matcher.replaceFirst("$1|");
    }

    private String _formatAnnotations(String fileName, String absolutePath, JavaClass javaClass, String fileContent, String annotationsBlock, String indent) throws Exception {
        List<String> annotations = SourceUtil.splitAnnotations(annotationsBlock, indent);
        for (String annotation : annotations) {
            String newAnnotation = this.formatAnnotation(fileName, absolutePath, javaClass, fileContent, annotation, indent);
            if (newAnnotation.contains("(")) {
                newAnnotation = this._formatAnnotations(fileName, absolutePath, javaClass, fileContent, newAnnotation, indent + "\t\t");
            }
            annotationsBlock = StringUtil.replace(annotationsBlock, annotation, newAnnotation);
        }
        return annotationsBlock;
    }
}

