/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringUtil;
import com.liferay.source.formatter.check.BaseJavaTermCheck;
import com.liferay.source.formatter.check.util.JavaSourceUtil;
import com.liferay.source.formatter.parser.JavaTerm;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaUpgradeCommerceShippingOptionCheck
extends BaseJavaTermCheck {
    private static final Pattern _commerceShippingOptionPattern = Pattern.compile("new (CommerceShippingOption\\((.+)\\))");

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) throws Exception {
        List<String> importNames = javaTerm.getImportNames();
        String javaTermContent = javaTerm.getContent();
        if (!importNames.contains("com.liferay.commerce.model.CommerceShippingOption")) {
            return javaTermContent;
        }
        Matcher matcher = _commerceShippingOptionPattern.matcher(javaTermContent);
        while (matcher.find()) {
            List<String> parameterList = JavaSourceUtil.getParameterList(matcher.group(1));
            if (parameterList.size() != 3) continue;
            String newInstance = StringUtil.replace(matcher.group(), matcher.group(2), this._getNewParameters(parameterList));
            javaTermContent = StringUtil.replace(javaTermContent, matcher.group(), newInstance);
        }
        return javaTermContent;
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_METHOD};
    }

    private String _getNewParameters(List<String> parameters) {
        StringBundler sb = new StringBundler(6);
        sb.append(parameters.get(2));
        sb.append(", \"\", ");
        sb.append(parameters.get(0));
        sb.append(", ");
        sb.append(parameters.get(0));
        sb.append(", 0");
        return sb.toString();
    }
}

