/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.WhitespaceCheck;
import com.liferay.source.formatter.check.util.SourceUtil;
import java.util.regex.Pattern;

public class MarkdownWhitespaceCheck
extends WhitespaceCheck {
    private static final Pattern _codeBlockPattern = Pattern.compile("```.+?```", 32);

    @Override
    protected String formatDoubleSpace(String line) {
        String trimmedLine = StringUtil.trim(line);
        if (trimmedLine.startsWith("*") || trimmedLine.matches("[0-9]+\\..*")) {
            return line;
        }
        return super.formatDoubleSpace(line);
    }

    @Override
    protected String trimLine(String fileName, String absolutePath, String content, String line, int lineNumber) {
        int[] multiLineStringsPositions = SourceUtil.getMultiLinePositions(content, _codeBlockPattern);
        if (SourceUtil.isInsideMultiLines(lineNumber, multiLineStringsPositions)) {
            return line;
        }
        return this.trimLine(fileName, absolutePath, line);
    }
}

