/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import java.io.IOException;
import java.util.Set;
import java.util.TreeSet;

public class PropertiesEnvironmentVariablesCheck
extends BaseFileCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        if (!this.isPortalSource() || !absolutePath.matches(".*/portal-impl/src/portal(_.*)?\\.properties") && !absolutePath.matches(".*/portal-impl/src/system.properties")) {
            return content;
        }
        return this._formatPortalProperties(fileName, content);
    }

    private String _addEnvVariables(String fileName, String content, String commentsBlock, String environmentVariablesBlock, String variablesContent, int lineNumber) {
        Set<String> environmentVariables = this._getEnvironmentVariables(fileName, variablesContent);
        if (environmentVariables.isEmpty()) {
            return content;
        }
        StringBundler sb = new StringBundler();
        if (Validator.isNull(commentsBlock) && Validator.isNull(environmentVariablesBlock)) {
            sb.append("\n");
            sb.append("    ");
            sb.append("#");
            sb.append("\n");
        }
        for (String environmentVariable : environmentVariables) {
            sb.append("    # Env: ");
            sb.append(environmentVariable);
            sb.append("\n");
        }
        sb.append("    ");
        sb.append("#");
        sb.append("\n");
        String environmentVariablesComment = sb.toString();
        if (environmentVariablesBlock.equals(environmentVariablesComment)) {
            return content;
        }
        int pos = this.getLineStartPos(content, lineNumber + 1);
        if (Validator.isNotNull(environmentVariablesBlock)) {
            return StringUtil.replaceFirst(content, environmentVariablesBlock, environmentVariablesComment, pos);
        }
        variablesContent = StringUtil.replaceLast(variablesContent, "\n", "");
        return StringUtil.replaceFirst(content, variablesContent, environmentVariablesComment + variablesContent, this.getLineStartPos(content, lineNumber + 1));
    }

    private String _formatPortalProperties(String fileName, String content) {
        StringBundler commentBlockSB = new StringBundler();
        StringBundler environmentVariablesBlockSB = new StringBundler();
        StringBundler variablesContentSB = new StringBundler();
        int lineNumber = 0;
        String[] lines = StringUtil.splitLines(content);
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (line.startsWith("        ") || line.matches("    #?\\w.*")) {
                variablesContentSB.append(line);
                variablesContentSB.append("\n");
                continue;
            }
            if (variablesContentSB.index() > 0) {
                String newContent = this._addEnvVariables(fileName, content, commentBlockSB.toString(), environmentVariablesBlockSB.toString(), variablesContentSB.toString(), lineNumber);
                if (!content.equals(newContent)) {
                    return newContent;
                }
                environmentVariablesBlockSB = new StringBundler();
                variablesContentSB = new StringBundler();
                lineNumber = i;
            }
            if (line.startsWith("    # Env: ") || environmentVariablesBlockSB.index() > 0 && line.equals("    #")) {
                environmentVariablesBlockSB.append(line);
                environmentVariablesBlockSB.append("\n");
                continue;
            }
            if (!line.equals("    #") && !line.startsWith("    # ")) continue;
            commentBlockSB.append(line);
            commentBlockSB.append("\n");
        }
        return this._addEnvVariables(fileName, content, commentBlockSB.toString(), environmentVariablesBlockSB.toString(), variablesContentSB.toString(), lineNumber);
    }

    private Set<String> _getEnvironmentVariables(String fileName, String s) {
        TreeSet<String> environmentVariables = new TreeSet<String>();
        for (String line : StringUtil.splitLines(s)) {
            int pos;
            String trimmedLine = StringUtil.trim(line);
            if (trimmedLine.startsWith("#")) {
                trimmedLine = trimmedLine.substring(1);
                trimmedLine = StringUtil.trim(trimmedLine);
            }
            if ((pos = trimmedLine.indexOf("=")) == -1) continue;
            String environmentVariable = ToolsUtil.encodeEnvironmentProperty(trimmedLine.substring(0, pos));
            if (fileName.endsWith("/system.properties")) {
                environmentVariable = environmentVariable.replaceFirst("LIFERAY_", "SYSTEM_LIFERAY_");
            }
            environmentVariables.add(environmentVariable);
        }
        return environmentVariables;
    }
}

