/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.JavaSourceUtil;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SetUtilMethodsCheck
extends BaseFileCheck {
    private static final Pattern _fromArrayPattern = Pattern.compile("SetUtil\\.fromArray\\(\\s*(?=new )");

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        return this._checkFromArrayCalls(content);
    }

    private String _checkFromArrayCalls(String content) {
        Matcher matcher = _fromArrayPattern.matcher(content);
        while (matcher.find()) {
            List<String> parameterList;
            if (ToolsUtil.isInsideQuotes(content, matcher.start()) || (parameterList = JavaSourceUtil.getParameterList(content.substring(matcher.start()))).size() != 1) continue;
            String parameter = parameterList.get(0);
            String arrayParameters = parameter.replaceFirst(".+\\{([\\s\\S]+)\\}", "$1");
            return this._fixFromArrayParamters(content, arrayParameters, matcher.start());
        }
        return content;
    }

    private String _fixFromArrayParamters(String content, String arraryParameters, int pos) {
        String call;
        int x = pos;
        while (ToolsUtil.getLevel(call = content.substring(pos, (x = content.indexOf(")", x + 1)) + 1), "(", ")") != 0 || ToolsUtil.getLevel(call, "{", "}") != 0) {
        }
        String replacement = StringBundler.concat("SetUtil.fromArray(", arraryParameters, ")");
        return StringUtil.replaceFirst(content, call, replacement, pos);
    }
}

