/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class YMLLongLinesCheck
extends BaseFileCheck {
    private static final String _MAX_LINE_LENGTH = "maxLineLength";
    private static final Log _log = LogFactoryUtil.getLog(YMLLongLinesCheck.class);
    private static final Pattern _descriptionPattern = Pattern.compile("(\n( +)description:(\n\\2 +#.*)*)((\n\\2 +.+)+)");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        int maxLineLength = 0;
        try {
            maxLineLength = Integer.parseInt(this.getAttributeValue(_MAX_LINE_LENGTH, absolutePath));
        }
        catch (NumberFormatException numberFormatException) {
            if (_log.isDebugEnabled()) {
                _log.debug(numberFormatException);
            }
            return content;
        }
        Matcher matcher = _descriptionPattern.matcher(content);
        while (matcher.find()) {
            String match = matcher.group(4);
            if (match.contains(": ")) continue;
            String description = StringUtil.trim(match.replaceAll("\n +", " "));
            String indent = matcher.group(2) + "    ";
            description = this._splitDescription(indent + description, indent, maxLineLength);
            description = "\n" + description;
            if (StringUtil.equals(match, description)) continue;
            return StringUtil.replaceFirst(content, match, description, matcher.start(4));
        }
        return content;
    }

    private String _splitDescription(String description, String indent, int maxLineLength) {
        if (description.length() <= maxLineLength) {
            return description;
        }
        int pos = description.indexOf(32, indent.length());
        if (pos == -1) {
            return description;
        }
        if (pos > maxLineLength) {
            return StringBundler.concat(description.substring(0, pos), "\n", this._splitDescription(indent + description.substring(pos + 1), indent, maxLineLength));
        }
        pos = description.lastIndexOf(32, maxLineLength);
        return StringBundler.concat(description.substring(0, pos), "\n", this._splitDescription(indent + description.substring(pos + 1), indent, maxLineLength));
    }
}

