/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.util;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.liferay.source.formatter.util.LegacyProperty;
import com.puppycrawl.tools.checkstyle.JavaParser;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.FileText;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class LegacyPropertiesUtil {
    public static List<LegacyProperty> getLegacyProperties(String fileName, String content) throws Exception {
        List<LegacyProperty> legacyProperties = new ArrayList<LegacyProperty>();
        List<String> lines = LegacyPropertiesUtil._getLines(content);
        FileText fileText = new FileText(new File(fileName), lines);
        FileContents fileContents = new FileContents(fileText);
        DetailAST rootDetailAST = JavaParser.parse((FileContents)fileContents);
        DetailAST nextSiblingDetailAST = rootDetailAST.getNextSibling();
        while (nextSiblingDetailAST.getType() != 14) {
            nextSiblingDetailAST = nextSiblingDetailAST.getNextSibling();
        }
        List<DetailAST> variableDefinitionDetailASTList = DetailASTUtil.getAllChildTokens(nextSiblingDetailAST, true, 10);
        for (DetailAST variableDefinitionDetailAST : variableDefinitionDetailASTList) {
            legacyProperties = LegacyPropertiesUtil._addLegacyProperties(legacyProperties, variableDefinitionDetailAST);
        }
        return legacyProperties;
    }

    private static List<LegacyProperty> _addLegacyProperties(List<LegacyProperty> legacyProperties, DetailAST variableDefinitionDetailAST) {
        DetailAST assignDetailAST = variableDefinitionDetailAST.findFirstToken(80);
        if (assignDetailAST == null) {
            return legacyProperties;
        }
        DetailAST firstChildDetailAST = assignDetailAST.getFirstChild();
        if (firstChildDetailAST.getType() != 29) {
            return legacyProperties;
        }
        DetailAST identDetailAST = variableDefinitionDetailAST.findFirstToken(58);
        String variableName = identDetailAST.getText();
        if (!variableName.contains("_PORTAL_") && !variableName.contains("_SYSTEM_")) {
            return legacyProperties;
        }
        List<DetailAST> arrayValueDetailASTList = LegacyPropertiesUtil._getArrayValueDetailASTList(firstChildDetailAST);
        for (DetailAST arrayValueDetailAST : arrayValueDetailASTList) {
            if (arrayValueDetailAST.getType() == 29) {
                legacyProperties = LegacyPropertiesUtil._addLegacyProperty(legacyProperties, variableName, LegacyPropertiesUtil._getArrayValueDetailASTList(arrayValueDetailAST));
                continue;
            }
            legacyProperties = LegacyPropertiesUtil._addLegacyProperty(legacyProperties, variableName, Arrays.asList(arrayValueDetailAST));
        }
        return legacyProperties;
    }

    private static List<LegacyProperty> _addLegacyProperty(List<LegacyProperty> legacyProperties, String variableName, List<DetailAST> detailASTList) {
        if (detailASTList.isEmpty()) {
            return legacyProperties;
        }
        String legacyPropertyName = LegacyPropertiesUtil._getStringValue(detailASTList.get(0));
        if (legacyPropertyName == null) {
            return legacyProperties;
        }
        String moduleName = null;
        String newPropertyName = null;
        if (detailASTList.size() > 1) {
            newPropertyName = LegacyPropertiesUtil._getStringValue(detailASTList.get(1));
            if (detailASTList.size() > 2) {
                moduleName = LegacyPropertiesUtil._getStringValue(detailASTList.get(2));
            }
        }
        legacyProperties.add(new LegacyProperty(legacyPropertyName, moduleName, newPropertyName, variableName));
        return legacyProperties;
    }

    private static List<DetailAST> _getArrayValueDetailASTList(DetailAST arrayInitDetailAST) {
        ArrayList<DetailAST> arrayValueDetailASTList = new ArrayList<DetailAST>();
        DetailAST childDetailAST = arrayInitDetailAST.getFirstChild();
        while (childDetailAST != null) {
            if (childDetailAST.getType() != 74 && childDetailAST.getType() != 73) {
                arrayValueDetailASTList.add(childDetailAST);
            }
            childDetailAST = childDetailAST.getNextSibling();
        }
        return arrayValueDetailASTList;
    }

    private static List<String> _getLines(String s) throws Exception {
        ArrayList<String> lines = new ArrayList<String>();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(s));){
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                lines.add(line);
            }
        }
        return lines;
    }

    private static String _getStringValue(DetailAST detailAST) {
        if (detailAST.getType() == 28) {
            detailAST = detailAST.getFirstChild();
        }
        if (detailAST.getType() == 139) {
            String text = detailAST.getText();
            return text.substring(1, text.length() - 1);
        }
        if (detailAST.getType() == 125) {
            String left = LegacyPropertiesUtil._getStringValue(detailAST.getFirstChild());
            String right = LegacyPropertiesUtil._getStringValue(detailAST.getLastChild());
            if (left != null && right != null) {
                return left + right;
            }
        }
        return null;
    }
}

