/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.util.SourceUtil;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author Peter Shin
 */
public class PropertiesCommentsCheck extends BaseFileCheck {

	@Override
	protected String doProcess(
		String fileName, String absolutePath, String content) {

		if (fileName.endsWith("/test.properties") &&
			!absolutePath.equals(
				SourceUtil.getRootDirName(absolutePath) + "/test.properties")) {

			content = _removeUnnecessaryComments(content);
		}

		return _formatComments(content);
	}

	private String _formatComments(String content) {
		Matcher matcher = _commentPattern1.matcher(content);

		while (matcher.find()) {
			if ((matcher.group(1) != null) || (matcher.group(3) != null)) {
				continue;
			}

			String comment = matcher.group(2);

			String titleCaseComment = StringUtil.getTitleCase(
				comment, true, _BRAND_NAMES);

			titleCaseComment = titleCaseComment.replaceAll(
				"(?i)(\\A|\\s)sf(\\Z|\\s)", "$1Source Formatter$2");

			if (!titleCaseComment.equals(comment)) {
				return StringUtil.replaceFirst(
					content, comment, titleCaseComment, matcher.start(2));
			}
		}

		return content;
	}

	private String _removeUnnecessaryComments(String content) {
		Matcher matcher = _commentPattern2.matcher(content);

		if (matcher.find()) {
			return content.substring(matcher.end());
		}

		return content;
	}

	private static final String[] _BRAND_NAMES = {
		"jQuery", "reCAPTCHA", "svg4everybody", "tc"
	};

	private static final Pattern _commentPattern1 = Pattern.compile(
		"([^#]\\s*)?\\n\\s*#+\\s+(\\w[\\s\\w]+)(\\n\\s*#+.*[\\w]+.*)?$",
		Pattern.MULTILINE);
	private static final Pattern _commentPattern2 = Pattern.compile(
		"\\A(##\n)*## DO NOT EDIT THIS FILE.*\n(##.*\n)*\n*");

}