/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import java.math.BigDecimal;
import java.math.RoundingMode;

public class BigDecimalUtil {
    public static double add(Number x, Number y) {
        if (x == null) {
            x = 0;
        }
        if (y == null) {
            y = 0;
        }
        BigDecimal xBigDecimal = new BigDecimal(x.toString());
        BigDecimal yBigDecimal = new BigDecimal(y.toString());
        BigDecimal resultBigDecimal = xBigDecimal.add(yBigDecimal);
        return resultBigDecimal.doubleValue();
    }

    public static double divide(Number x, Number y, int scale, RoundingMode roundingMode) {
        if (x == null) {
            x = 0;
        }
        if (y == null) {
            y = 0;
        }
        BigDecimal xBigDecimal = new BigDecimal(x.toString());
        BigDecimal yBigDecimal = new BigDecimal(y.toString());
        BigDecimal resultBigDecimal = xBigDecimal.divide(yBigDecimal, scale, roundingMode);
        return resultBigDecimal.doubleValue();
    }

    public static boolean eq(BigDecimal value1, BigDecimal value2) {
        if (value1 == null && value2 == null) {
            return true;
        }
        return value1 != null && value2 != null && value1.compareTo(value2) == 0;
    }

    public static BigDecimal get(Object newValue, BigDecimal defaultValue) {
        if (newValue != null) {
            if (newValue instanceof Integer) {
                return BigDecimal.valueOf(((Integer)newValue).intValue());
            }
            if (newValue instanceof Double) {
                return BigDecimal.valueOf((Double)newValue);
            }
            if (newValue instanceof BigDecimal) {
                return (BigDecimal)newValue;
            }
        }
        return defaultValue;
    }

    public static boolean gt(BigDecimal value1, BigDecimal value2) {
        if (value1 == null || value2 == null) {
            return false;
        }
        return value1.compareTo(value2) > 0;
    }

    public static boolean gte(BigDecimal value1, BigDecimal value2) {
        if (value1 == null && value2 == null) {
            return true;
        }
        return value1 != null && value2 != null && value1.compareTo(value2) >= 0;
    }

    public static boolean isZero(BigDecimal value) {
        return value == null || value.compareTo(BigDecimal.ZERO) == 0;
    }

    public static boolean lt(BigDecimal value1, BigDecimal value2) {
        if (value1 == null || value2 == null) {
            return false;
        }
        return value1.compareTo(value2) < 0;
    }

    public static boolean lte(BigDecimal value1, BigDecimal value2) {
        if (value1 == null && value2 == null) {
            return true;
        }
        return value1 != null && value2 != null && value1.compareTo(value2) <= 0;
    }

    public static double multiply(Number x, Number y) {
        if (x == null) {
            x = 0;
        }
        if (y == null) {
            y = 0;
        }
        BigDecimal xBigDecimal = new BigDecimal(x.toString());
        BigDecimal yBigDecimal = new BigDecimal(y.toString());
        BigDecimal resultBigDecimal = xBigDecimal.multiply(yBigDecimal);
        return resultBigDecimal.doubleValue();
    }

    public static double scale(Number x, int scale, RoundingMode roundingMode) {
        if (x == null) {
            x = 0;
        }
        BigDecimal xBigDecimal = new BigDecimal(x.toString());
        xBigDecimal = xBigDecimal.setScale(scale, roundingMode);
        return xBigDecimal.doubleValue();
    }

    public static double subtract(Number x, Number y) {
        if (x == null) {
            x = 0;
        }
        if (y == null) {
            y = 0;
        }
        BigDecimal xBigDecimal = new BigDecimal(x.toString());
        BigDecimal yBigDecimal = new BigDecimal(y.toString());
        BigDecimal resultBigDecimal = xBigDecimal.subtract(yBigDecimal);
        return resultBigDecimal.doubleValue();
    }
}

