/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.core;

import com.liferay.poshi.core.util.GetterUtil;
import com.liferay.poshi.core.util.ListUtil;
import com.liferay.poshi.core.util.StringUtil;
import com.liferay.poshi.core.util.Validator;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class PoshiProperties
extends Properties {
    public static final String ACCESSIBILITY_STANDARDS_TAGS = "accessibility.standards.tags";
    public static final String BROWSER_CHROME_BIN_ARGS = "browser.chrome.bin.args";
    public static final String BROWSER_CHROME_BIN_FILE = "browser.chrome.bin.file";
    public static final String BROWSER_FIREFOX_BIN_FILE = "browser.firefox.bin.file";
    public static final String BROWSER_TYPE = "browser.type";
    public static final String BROWSER_VERSION = "browser.version";
    public static final String DEBUG_STACKTRACE = "debug.stacktrace";
    public static final String GENERATE_COMMAND_SIGNATURE = "generate.command.signature";
    public static final String GET_LOCATION_MAX_RETRIES = "get.location.max.retries";
    public static final String GET_LOCATION_TIMEOUT = "get.location.timeout";
    public static final String IGNORE_ERRORS = "ignore.errors";
    public static final String IGNORE_ERRORS_DELIMITER = "ignore.errors.delimiter";
    public static final String IGNORE_ERRORS_FILE_NAME = "ignore.errors.file.name";
    public static final String LIFERAY_DATA_GUARD_ENABLED = "liferay.data.guard.enabled";
    public static final String LIFERAY_PORTAL_BRANCH = "liferay.portal.branch";
    public static final String LIFERAY_PORTAL_BUNDLE = "liferay.portal.bundle";
    public static final String LOGGER_RESOURCES_URL = "logger.resources.url";
    public static final String OUTPUT_DIR_NAME = "output.dir.name";
    public static final String PORTAL_URL = "portal.url";
    public static final String POSHI_FILE_READ_THREAD_POOL = "poshi.file.read.thread.pool";
    public static final String PRINT_JAVA_PROCESS_ON_FAIL = "print.java.process.on.fail";
    public static final String PROJECT_DIR = "project.dir";
    public static final String PROXY_SERVER_ENABLED = "proxy.server.enabled";
    public static final String PROXY_SERVER_PORT = "proxy.server.port";
    public static final String REPORT_TYPE = "report.type";
    public static final String SAVE_SCREENSHOT = "save.screenshot";
    public static final String SAVE_WEB_PAGE = "save.web.page";
    public static final String SELENIUM_CHROME_DRIVER_EXECUTABLE = "selenium.chrome.driver.executable";
    public static final String SELENIUM_DESIRED_CAPABILITIES_PLATFORM = "selenium.desired.capabilities.platform";
    public static final String SELENIUM_EDGE_DRIVER_EXECUTABLE = "selenium.edge.driver.executable";
    public static final String SELENIUM_EXECUTABLE_DIR_NAME = "selenium.executable.dir.name";
    public static final String SELENIUM_GECKO_DRIVER_EXECUTABLE = "selenium.gecko.driver.executable";
    public static final String SELENIUM_IE_DRIVER_EXECUTABLE = "selenium.ie.driver.executable";
    public static final String SELENIUM_REMOTE_DRIVER_ENABLED = "selenium.remote.driver.enabled";
    public static final String SELENIUM_REMOTE_DRIVER_URL = "selenium.remote.driver.url";
    public static final String TCAT_ADMIN_REPOSITORY = "tcat.admin.repository";
    public static final String TCAT_ENABLED = "tcat.enabled";
    public static final String TEST_ASSERT_CONSOLE_ERRORS = "test.assert.console.errors";
    public static final String TEST_ASSERT_JAVASCRIPT_ERRORS = "test.assert.javascript.errors";
    public static final String TEST_ASSERT_WARNING_EXCEPTIONS = "test.assert.warning.exceptions";
    public static final String TEST_BASE_DIR_NAME = "test.base.dir.name";
    public static final String TEST_BATCH_GROUP_IGNORE_REGEX = "test.batch.group.ignore.regex";
    public static final String TEST_BATCH_MAX_GROUP_SIZE = "test.batch.max.group.size";
    public static final String TEST_BATCH_MAX_SUBGROUP_SIZE = "test.batch.max.subgroup.size";
    public static final String TEST_BATCH_PROPERTY_QUERY = "test.batch.property.query";
    public static final String TEST_BATCH_RUN_TYPE = "test.batch.run.type";
    public static final String TEST_CASE_AVAILABLE_PROPERTY_NAMES = "test.case.available.property.names";
    public static final String TEST_CASE_REQUIRED_PROPERTY_NAMES = "test.case.required.property.names";
    public static final String TEST_CSV_REPORT_PROPERTY_NAMES = "test.csv.report.property.names";
    public static final String TEST_DEPENDENCIES_DIR_NAME = "test.dependencies.dir.name";
    public static final String TEST_DIRS = "test.dirs";
    public static final String TEST_JVM_MAX_RETRIES = "test.jvm.max.retries";
    public static final String TEST_LIFERAY_CONSOLE_LOG_FILE_NAME = "test.liferay.console.log.file.name";
    public static final String TEST_LIFERAY_CONSOLE_SHUT_DOWN_FILE_NAME = "test.liferay.console.shut.down.file.name";
    public static final String TEST_NAME = "test.name";
    public static final String TEST_POSHI_SCRIPT_VALIDATION = "test.poshi.script.validation";
    public static final String TEST_POSHI_WARNINGS_FILE_NAME = "test.poshi.warnings.file.name";
    public static final String TEST_RETRY_COMMAND_WAIT_TIME = "test.retry.command.wait.time";
    public static final String TEST_RUN_ENVIRONMENT = "test.run.environment";
    public static final String TEST_RUN_LOCALLY = "test.run.locally";
    public static final String TEST_RUN_THREAD_POOL_SIZE = "test.run.thread.pool.size";
    public static final String TEST_RUN_TYPE = "test.run.type";
    public static final String TEST_SKIP_TEAR_DOWN = "test.skip.tear.down";
    public static final String TEST_SUPPORT_DIRS = "test.support.dirs";
    public static final String TEST_TESTCASE_MAX_RETRIES = "test.testcase.max.retries";
    public static final String TIMEOUT_EXPLICIT_WAIT = "timeout.explicit.wait";
    public static final String TIMEOUT_IMPLICIT_WAIT = "timeout.implicit.wait";
    public static final String VALIDATION_RESOURCE_FILE_TYPES = "validation.resource.file.types";
    public String accessibilityStandardsTags = this.getProperty("accessibility.standards.tags");
    public String browserChromeBinArgs = this.getProperty("browser.chrome.bin.args");
    public String browserChromeBinFile = this.getProperty("browser.chrome.bin.file");
    public String browserFirefoxBinFile = this.getProperty("browser.firefox.bin.file");
    public String browserType = this.getProperty("browser.type");
    public String browserVersion = this.getProperty("browser.version");
    public Boolean debugStacktrace = GetterUtil.getBoolean(this.getProperty("debug.stacktrace"));
    public Boolean generateCommandSignature = GetterUtil.getBoolean(this.getProperty("generate.command.signature"));
    public int getLocationMaxRetries = GetterUtil.getInteger(this.getProperty("get.location.max.retries"));
    public int getLocationTimeout = GetterUtil.getInteger(this.getProperty("get.location.timeout"));
    public String ignoreErrors = this.getProperty("ignore.errors");
    public String ignoreErrorsDelimiter = this.getProperty("ignore.errors.delimiter");
    public String ignoreErrorsFileName = this.getProperty("ignore.errors.file.name");
    public Boolean liferayDataGuardEnabled = GetterUtil.get(this.getProperty("liferay.data.guard.enabled"), false);
    public String liferayPortalBranch = this.getProperty("liferay.portal.branch");
    public String liferayPortalBundle = this.getProperty("liferay.portal.bundle");
    public String loggerResourcesURL = this.getProperty("logger.resources.url");
    public String outputDirName = this.getProperty("output.dir.name");
    public String portalURL = this.getProperty("portal.url");
    public int poshiFileReadThreadPool = GetterUtil.getInteger(this.getProperty("poshi.file.read.thread.pool"));
    public String printJavaProcessOnFail = this.getProperty("print.java.process.on.fail");
    public String projectDir = this.getProperty("project.dir");
    public Boolean proxyServerEnabled = GetterUtil.getBoolean(this.getProperty("proxy.server.enabled"));
    public int proxyServerPort = GetterUtil.getInteger(this.getProperty("proxy.server.port"));
    public Boolean reportType = GetterUtil.getBoolean(this.getProperty("report.type"));
    public boolean saveScreenshot = GetterUtil.getBoolean(this.getProperty("save.screenshot"));
    public boolean saveWebPage = GetterUtil.getBoolean(this.getProperty("save.web.page"));
    public String seleniumChromeDriverExecutable = this.getProperty("selenium.chrome.driver.executable");
    public String seleniumDesiredCapabilitiesPlatform = this.getProperty("selenium.desired.capabilities.platform");
    public String seleniumEdgeDriverExecutable = this.getProperty("selenium.edge.driver.executable");
    public String seleniumExecutableDirName = this.getProperty("selenium.executable.dir.name");
    public String seleniumGeckoDriverExecutable = this.getProperty("selenium.gecko.driver.executable");
    public String seleniumIeDriverExecutable = this.getProperty("selenium.ie.driver.executable");
    public boolean seleniumRemoteDriverEnabled = GetterUtil.getBoolean(this.getProperty("selenium.remote.driver.enabled"));
    public String seleniumRemoteDriverURL = this.getProperty("selenium.remote.driver.url");
    public String tcatAdminRepository = this.getProperty("tcat.admin.repository");
    public boolean tcatEnabled = GetterUtil.getBoolean(this.getProperty("tcat.enabled"));
    public boolean testAssertConsoleErrors = GetterUtil.getBoolean(this.getProperty("test.assert.console.errors"));
    public boolean testAssertJavascriptErrors = GetterUtil.getBoolean(this.getProperty("test.assert.javascript.errors"));
    public boolean testAssertWarningExceptions = GetterUtil.getBoolean(this.getProperty("test.assert.warning.exceptions"));
    public String testBaseDirName = this.getProperty("test.base.dir.name");
    public String testBatchGroupIgnoreRegex = this.getProperty("test.batch.group.ignore.regex");
    public int testBatchMaxGroupSize = GetterUtil.getInteger(this.getProperty("test.batch.max.group.size"));
    public int testBatchMaxSubgroupSize = GetterUtil.getInteger(this.getProperty("test.batch.max.subgroup.size"));
    public String testBatchPropertyQuery = this.getProperty("test.batch.property.query");
    public String testBatchRunType = this.getProperty("test.batch.run.type");
    public String testCaseAvailablePropertyNames = this.getProperty("test.case.available.property.names");
    public String testCaseRequiredPropertyNames = this.getProperty("test.case.required.property.names");
    public String[] testCSVReportPropertyNames = StringUtil.split(this.getProperty("test.csv.report.property.names"));
    public String testDependenciesDirName = this.getProperty("test.dependencies.dir.name");
    public String[] testDirs = StringUtil.split(this.getProperty("test.dirs"));
    public int testJVMMaxRetries = GetterUtil.getInteger(this.getProperty("test.jvm.max.retries"));
    public String testLiferayConsoleLogFileName = this.getProperty("test.liferay.console.log.file.name");
    public String testLiferayConsoleShutDownFileName = this.getProperty("test.liferay.console.log.file.name");
    public String testName = this.getProperty("test.name");
    public boolean testPoshiScriptValidation = GetterUtil.getBoolean(this.getProperty("test.poshi.script.validation"));
    public String testPoshiWarningsFileName = this.getProperty("test.poshi.warnings.file.name");
    public int testRetryCommandWaitTime = GetterUtil.getInteger(this.getProperty("test.retry.command.wait.time"));
    public String testRunEnvironment = this.getProperty("test.run.environment");
    public boolean testRunLocally = GetterUtil.getBoolean(this.getProperty("test.run.locally"));
    public int testRunThreadPoolSize = GetterUtil.getInteger(this.getProperty("test.run.thread.pool.size"));
    public String testRunType = this.getProperty("test.run.type");
    public boolean testSkipTearDown = GetterUtil.getBoolean(this.getProperty("test.skip.tear.down"));
    public String[] testSupportDirs = StringUtil.split(this.getProperty("test.support.dirs"));
    public int testTestcaseMaxRetries = GetterUtil.getInteger(this.getProperty("test.testcase.max.retries"));
    public int timeoutExplicitWait = GetterUtil.getInteger(this.getProperty("timeout.explicit.wait"));
    public int timeoutImplicitWait = GetterUtil.getInteger(this.getProperty("timeout.implicit.wait"));
    public String[] validationResourceFileTypes = StringUtil.split(this.getProperty("validation.resource.file.types"));
    private static final Properties _classProperties = new Properties();
    private static final PoshiProperties _poshiProperties;
    private static final Map<String, PoshiProperties> _threadBasedPoshiProperties;

    public static synchronized void addThreadBasedPoshiProperties() {
        Thread thread = Thread.currentThread();
        if (_threadBasedPoshiProperties.containsKey(thread.getName())) {
            return;
        }
        Properties properties = new Properties(_poshiProperties);
        Class<PoshiProperties> clazz = PoshiProperties.class;
        try {
            for (Field field : clazz.getFields()) {
                if (!Modifier.isFinal(field.getModifiers()) || !(field.get(field) instanceof String)) continue;
                String propertyName = (String)field.get(field);
                String propertyValue = System.getProperty("thread." + propertyName);
                if (Validator.isNull(propertyValue)) {
                    propertyValue = _classProperties.getProperty("thread." + propertyName);
                }
                if (!Validator.isNotNull(propertyValue)) continue;
                String[] propertyValues = propertyValue.split(",");
                int index = _threadBasedPoshiProperties.size();
                if (index >= propertyValues.length) continue;
                properties.setProperty(propertyName, propertyValues[index]);
            }
            _threadBasedPoshiProperties.put(thread.getName(), new PoshiProperties(properties));
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
    }

    public static PoshiProperties getPoshiProperties() {
        Thread thread = Thread.currentThread();
        if (PoshiProperties._poshiProperties.testRunType.equals("parallel") && _threadBasedPoshiProperties.containsKey(thread.getName())) {
            return _threadBasedPoshiProperties.get(thread.getName());
        }
        return _poshiProperties;
    }

    public PoshiProperties() {
    }

    public PoshiProperties(Properties properties) {
        super(properties);
        this.printProperties(false);
    }

    public void printProperties(boolean update) {
        List<?> keys = Collections.list(this.propertyNames());
        keys = ListUtil.sort(keys);
        if (update) {
            System.out.println("-- updated properties --");
        } else {
            System.out.println("-- listing properties --");
        }
        for (String key : keys) {
            System.out.println(key + "=" + this.getProperty(key));
        }
        System.out.println("");
    }

    static {
        _threadBasedPoshiProperties = Collections.synchronizedMap(new HashMap());
        Class<PoshiProperties> clazz = PoshiProperties.class;
        ClassLoader classLoader = clazz.getClassLoader();
        for (String string : Arrays.asList("poshi.properties", "poshi-ext.properties")) {
            InputStream inputStream = classLoader.getResourceAsStream(string);
            if (inputStream == null) continue;
            try {
                _classProperties.load(inputStream);
            }
            catch (IOException ioException) {
                ioException.printStackTrace();
            }
        }
        Properties properties = new Properties();
        try {
            for (Field field : clazz.getFields()) {
                if (!Modifier.isFinal(field.getModifiers()) || !(field.get(field) instanceof String)) continue;
                String propertyName = (String)field.get(field);
                String propertyValue = System.getProperty(propertyName);
                if (Validator.isNull(propertyValue)) {
                    propertyValue = _classProperties.getProperty(propertyName);
                }
                if (!Validator.isNotNull(propertyValue)) continue;
                properties.setProperty(propertyName, propertyValue);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        _poshiProperties = new PoshiProperties(properties);
    }
}

