/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.JavaSourceUtil;
import java.util.List;

public abstract class BaseUpgradeCheck
extends BaseFileCheck {
    public boolean hasValidParameters(int expectedParametersSize, String fileName, String javaMethodContent, String message, List<String> parameterList, String[] parameterTypes) {
        if (parameterList.size() != expectedParametersSize) {
            return false;
        }
        if (!this.hasParameterTypes(javaMethodContent, javaMethodContent, ArrayUtil.toStringArray(parameterList), parameterTypes)) {
            this.addMessage(fileName, message);
            return false;
        }
        return true;
    }

    protected String addNewImports(String newContent) {
        String[] newImports = this.getNewImports();
        if (newImports != null) {
            newContent = JavaSourceUtil.addImports(newContent, newImports);
        }
        return newContent;
    }

    protected String afterFormat(String fileName, String absolutePath, String content, String newContent) {
        return this.addNewImports(newContent);
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        if (!this.isValidExtension(fileName)) {
            return content;
        }
        String newContent = this.format(fileName, absolutePath, content);
        if (!content.equals(newContent)) {
            newContent = this.afterFormat(fileName, absolutePath, content, newContent);
        }
        return newContent;
    }

    protected abstract String format(String var1, String var2, String var3) throws Exception;

    protected String[] getNewImports() {
        return null;
    }

    protected String[] getValidExtensions() {
        return new String[]{"java"};
    }

    protected boolean isValidExtension(String fileName) {
        for (String extension : this.getValidExtensions()) {
            if (!fileName.endsWith('.' + extension)) continue;
            return true;
        }
        return false;
    }
}

