/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringUtil;
import com.liferay.source.formatter.check.BaseUpgradeCheck;
import com.liferay.source.formatter.check.util.JavaSourceUtil;
import com.liferay.source.formatter.check.util.SourceUtil;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaClassParser;
import com.liferay.source.formatter.parser.JavaMethod;
import com.liferay.source.formatter.parser.JavaTerm;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UpgradeJavaUserLocalServiceUtilCheck
extends BaseUpgradeCheck {
    private static final Pattern _addUserPattern = Pattern.compile("(\\w+)\\.\\s*addUser\\(\\s*.+(,\\s*.+)+\\)");
    private static final Pattern _updateStatusPattern = Pattern.compile("(|\\t*\\w+\\s*\\=|\\t*return?)\\t*\\s?(\\w+\\.updateStatus\\()");

    @Override
    protected String format(String fileName, String absolutePath, String content) throws Exception {
        JavaClass javaClass = JavaClassParser.parseJavaClass(fileName, content);
        for (JavaTerm childJavaTerm : javaClass.getChildJavaTerms()) {
            if (!childJavaTerm.isJavaMethod()) continue;
            JavaMethod javaMethod = (JavaMethod)childJavaTerm;
            String javaMethodContent = javaMethod.getContent();
            content = StringUtil.replace(content, javaMethodContent, this._checkAddUser(javaMethodContent, content));
            content = StringUtil.replace(content, javaMethodContent, this._checkUpdateStatus(javaMethodContent, content, fileName));
        }
        return content;
    }

    @Override
    protected String[] getNewImports() {
        return new String[]{"com.liferay.portal.kernel.service.ServiceContextThreadLocal"};
    }

    private String _checkAddUser(String content, String fileContent) {
        Matcher addUserMatcher = _addUserPattern.matcher(content);
        while (addUserMatcher.find()) {
            String methodCall = addUserMatcher.group();
            List<String> parameterList = JavaSourceUtil.getParameterList(methodCall);
            if (!this._checkMethodCall(content, fileContent, methodCall) || parameterList.size() != 26 && parameterList.size() != 31) continue;
            String line = this.getLine(content, this.getLineNumber(content, addUserMatcher.start()));
            String variableName = this.getVariableName(methodCall);
            content = StringUtil.replace(content, methodCall, this._removeParameters(SourceUtil.getIndent(line), methodCall, parameterList, variableName));
        }
        return content;
    }

    private boolean _checkMethodCall(String content, String fileContent, String methodCall) {
        String variableName = this.getVariableName(methodCall);
        return variableName.equals("UserLocalServiceUtil") || variableName.equals("UserServiceUtil") || this.hasClassOrVariableName("UserLocalService", content, fileContent, methodCall) || this.hasClassOrVariableName("UserService", content, fileContent, methodCall);
    }

    private String _checkUpdateStatus(String content, String fileContent, String fileName) {
        Matcher updateStatusMatcher = _updateStatusPattern.matcher(content);
        String newContent = content;
        while (updateStatusMatcher.find()) {
            String methodCall = JavaSourceUtil.getMethodCall(content, updateStatusMatcher.start());
            String message = StringBundler.concat("Could not resolve types of updateStatus method. The method ", "signature has changed to updateStatus(long userId,", "int status, ServiceContext serviceContext). Fill the new ", "parameter manually.");
            List<String> parameterList = JavaSourceUtil.getParameterList(methodCall);
            if (!this._checkMethodCall(content, fileContent, updateStatusMatcher.group(2)) || !this.hasValidParameters(2, fileName, content, message, parameterList, new String[]{"long", "int"})) continue;
            String newMethodCall = JavaSourceUtil.addMethodNewParameters(JavaSourceUtil.getIndent(methodCall), new int[]{2}, updateStatusMatcher.group(), new String[]{"ServiceContextThreadLocal.getServiceContext()"}, parameterList);
            newContent = StringUtil.replace(newContent, methodCall, newMethodCall);
        }
        return newContent;
    }

    private String _removeParameters(String indent, String methodCall, List<String> parameterList, String variableName) {
        parameterList.remove(7);
        parameterList.remove(7);
        StringBundler sb = new StringBundler();
        sb.append(variableName);
        sb.append(".addUser(\n");
        sb.append(indent);
        sb.append("\t");
        sb.append(parameterList.get(0));
        for (int i = 1; i < parameterList.size(); ++i) {
            if (i % 4 == 0) {
                sb.append(",");
                sb.append("\n");
                sb.append(indent);
                sb.append("\t");
                sb.append(parameterList.get(i));
                continue;
            }
            sb.append(", ");
            sb.append(parameterList.get(i));
        }
        sb.append(")");
        return StringUtil.replace(methodCall, methodCall, sb.toString());
    }
}

