/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XMLDTDVersionCheck
extends BaseFileCheck {
    private static final String _RELEASE_PROPERTIES_FILE_NAME = "release.properties";
    private static final Pattern _doctypePattern = Pattern.compile("(<!DOCTYPE .+ PUBLIC \"-//Liferay//DTD .+ )([0-9]+\\.[0-9]+\\.[0-9]+)(//EN\" \"http://www.liferay.com/dtd/.+_)([0-9]+_[0-9]+_[0-9]+)(\\.dtd\">)");
    private Properties _releaseProperties;

    protected String checkDTDVersion(String content) throws IOException {
        Matcher matcher = _doctypePattern.matcher(content);
        if (!matcher.find()) {
            return content;
        }
        String lpVersion = this.getLPVersion();
        if (lpVersion == null) {
            return content;
        }
        String lpVersionDTD = this.getLPVersionDTD();
        if (lpVersionDTD == null) {
            return content;
        }
        return StringUtil.replaceFirst(content, matcher.group(), StringBundler.concat(matcher.group(1), lpVersion, matcher.group(3), lpVersionDTD, matcher.group(5)), matcher.start());
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        this._readReleaseProperties();
        if (this._releaseProperties == null || !fileName.endsWith(".xml")) {
            return content;
        }
        return this.checkDTDVersion(content);
    }

    protected String getLPVersion() {
        return this._releaseProperties.getProperty("lp.version");
    }

    protected String getLPVersionDTD() {
        return this._releaseProperties.getProperty("lp.version.dtd");
    }

    private void _readReleaseProperties() throws IOException {
        if (this._releaseProperties != null) {
            return;
        }
        File releasePropertiesFile = new File(this.getPortalDir(), _RELEASE_PROPERTIES_FILE_NAME);
        if (!releasePropertiesFile.exists()) {
            return;
        }
        this._releaseProperties = new Properties();
        this._releaseProperties.load(Files.newInputStream(releasePropertiesFile.toPath(), new OpenOption[0]));
    }
}

